/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.house;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.house.HouseSavedData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.INBTSerializable;

public class Domain
implements INBTSerializable<CompoundTag> {
    private String lordUUID;
    private String knightUUID;
    private Component domainTitle;
    private String claimId;
    private HashSet<String> players = new HashSet();
    private int[] domainFoundationCoordinates = new int[3];
    private final EnumMap<DomainDebuffs, Boolean> domainDebuffs = new EnumMap(DomainDebuffs.class);
    private final HashMap<String, Integer> suspectPlayers = new HashMap();
    private int domainHP;

    public Domain() {
        this.domainTitle = Component.m_237113_((String)"");
        this.lordUUID = null;
        this.knightUUID = null;
        this.claimId = null;
        this.domainHP = -1;
        for (DomainDebuffs debuff : DomainDebuffs.values()) {
            this.domainDebuffs.put(debuff, false);
        }
    }

    public Domain(String lordUUID, String knightUUID, Component knightDisplayName) {
        this.lordUUID = lordUUID;
        this.knightUUID = knightUUID;
        this.domainTitle = knightDisplayName;
        this.players.add(knightUUID);
        this.claimId = null;
        this.domainHP = 300;
        for (DomainDebuffs debuff : DomainDebuffs.values()) {
            this.domainDebuffs.put(debuff, false);
        }
    }

    public Domain(CompoundTag nbt) {
        this.deserializeNBT(nbt);
    }

    public String getLordUUID() {
        return this.lordUUID;
    }

    public String getKnightUUID() {
        return this.knightUUID;
    }

    public Component getDomainTitle() {
        return this.domainTitle;
    }

    public HashSet<String> getPlayers() {
        return this.players;
    }

    public int[] getDomainFoundationCoordinates() {
        return this.domainFoundationCoordinates;
    }

    public void setDomainFoundationCoordinates(int[] coordinates) {
        this.domainFoundationCoordinates = coordinates;
        HouseSavedData.getInstance().m_77762_();
    }

    public int getDomainHP() {
        return this.domainHP;
    }

    public void setDomainHP(int domainHP) {
        this.domainHP = Math.min(300, Math.max(0, domainHP));
    }

    public int addDomainHP(int amount) {
        this.setDomainHP(this.domainHP + amount);
        return this.domainHP;
    }

    public void setDomainTitle(Component domainTitle) {
        this.domainTitle = domainTitle;
    }

    public void setLordUUID(String lordUUID) {
        this.lordUUID = lordUUID;
    }

    public void setKnightUUID(String knightUUID) {
        this.knightUUID = knightUUID;
    }

    public void setPlayers(HashSet<String> players) {
        this.players = players;
    }

    public boolean isNull() {
        return Objects.equals(this.knightUUID, null);
    }

    public boolean isPlayerInDomain(String playerUUID) {
        return this.players.contains(playerUUID);
    }

    public void pushPlayer(String player) {
        this.players.add(player);
    }

    public void removePlayer(String player) {
        this.players.remove(player);
    }

    public void adjustSuspicionForPlayer(String playerId, int amount) {
        int current = this.suspectPlayers.getOrDefault(playerId, 0);
        int updated = current + amount;
        if (updated <= 0) {
            this.suspectPlayers.remove(playerId);
            return;
        }
        if (updated >= 100) {
            this.suspectPlayers.remove(playerId);
            HouseManager.getHouseByLordUUID(this.getLordUUID()).addWantedPlayer(playerId);
            return;
        }
        this.suspectPlayers.put(playerId, updated);
        HouseSavedData.getInstance().m_77762_();
    }

    public void adjustSuspicionForAll(int amount) {
        ArrayList<String> keys = new ArrayList<String>(this.suspectPlayers.keySet());
        for (String playerId : keys) {
            this.adjustSuspicionForPlayer(playerId, amount);
        }
        HouseSavedData.getInstance().m_77762_();
    }

    public List<Map.Entry<String, Integer>> getSortedSuspects(int maxCount) {
        Vector<Map.Entry<String, Integer>> list = new Vector<Map.Entry<String, Integer>>(this.suspectPlayers.entrySet());
        list.sort((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue()));
        if (maxCount > 0 && maxCount < list.size()) {
            return list.subList(0, maxCount);
        }
        return list;
    }

    public String getClaimId() {
        return this.claimId;
    }

    public void setClaimId(String claimId) {
        this.claimId = claimId;
        HouseSavedData.getInstance().m_77762_();
    }

    public Boolean getDebuff(DomainDebuffs debuff) {
        return this.domainDebuffs.get((Object)debuff);
    }

    public void toggleOnDebuff(DomainDebuffs debuff) {
        this.domainDebuffs.put(debuff, true);
        HouseSavedData.getInstance().m_77762_();
    }

    public void toggleOffDebuff(DomainDebuffs debuff) {
        this.domainDebuffs.put(debuff, false);
        HouseSavedData.getInstance().m_77762_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("lord_uuid", this.lordUUID);
        tag.m_128359_("knight_uuid", this.knightUUID);
        tag.m_128359_("domain_title", this.domainTitle.getString());
        tag.m_128405_("domain_hp", this.domainHP);
        tag.m_128385_("domain_foundation_coordinates", this.domainFoundationCoordinates);
        ListTag playersTag = new ListTag();
        this.players.forEach(player -> playersTag.add((Object)StringTag.m_129297_((String)player)));
        tag.m_128365_("players", (Tag)playersTag);
        ListTag suspectList = new ListTag();
        for (Map.Entry<String, Integer> entry : this.suspectPlayers.entrySet()) {
            CompoundTag eTag = new CompoundTag();
            eTag.m_128359_("player_id", entry.getKey());
            eTag.m_128405_("suspicion", entry.getValue().intValue());
            suspectList.add((Object)eTag);
        }
        tag.m_128365_("suspects", (Tag)suspectList);
        CompoundTag debuffsTag = new CompoundTag();
        for (Map.Entry<DomainDebuffs, Boolean> entry : this.domainDebuffs.entrySet()) {
            if (entry.getValue() == null) continue;
            debuffsTag.m_128379_(entry.getKey().name(), entry.getValue().booleanValue());
        }
        tag.m_128365_("domain_debuffs", (Tag)debuffsTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.lordUUID = nbt.m_128461_("lord_uuid");
        this.knightUUID = nbt.m_128461_("knight_uuid");
        this.domainTitle = Component.m_237113_((String)nbt.m_128461_("domain_title"));
        this.domainHP = nbt.m_128451_("domain_hp");
        this.domainFoundationCoordinates = nbt.m_128465_("domain_foundation_coordinates");
        this.players.clear();
        ListTag playersTag = nbt.m_128437_("players", 8);
        playersTag.forEach(tag -> this.players.add(tag.m_7916_()));
        this.suspectPlayers.clear();
        if (nbt.m_128441_("suspects")) {
            ListTag suspectList = nbt.m_128437_("suspects", 10);
            for (int i = 0; i < suspectList.size(); ++i) {
                CompoundTag eTag = suspectList.m_128728_(i);
                String pid = eTag.m_128461_("player_id");
                int susValue = eTag.m_128451_("suspicion");
                this.suspectPlayers.put(pid, susValue);
            }
        }
        if (nbt.m_128441_("domain_debuffs")) {
            CompoundTag debuffsTag = nbt.m_128469_("domain_debuffs");
            for (String key : debuffsTag.m_128431_()) {
                DomainDebuffs pos = DomainDebuffs.valueOf(key);
                this.domainDebuffs.put(pos, debuffsTag.m_128471_(key));
            }
        }
    }

    public static enum DomainDebuffs {
        disease,
        robbers;

    }
}

