/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.house;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.mcreator.reignmod.house.Domain;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.house.HouseNeedType;
import net.mcreator.reignmod.house.HouseSavedData;
import net.mcreator.reignmod.procedures.ClearHouseProcedure;
import net.mcreator.reignmod.procedures.IncubatorUpdateInfoProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.util.INBTSerializable;

public class House
implements INBTSerializable<CompoundTag> {
    private String lordUUID;
    private String houseTitle;
    private String houseColor;
    private String claimId = null;
    private int houseHP;
    private HashSet<String> players;
    private int[] housePlusCoordinates = new int[3];
    private int[] houseIncubatorCoordinates = new int[3];
    private int[] housePrisonCoordinates = new int[3];
    private final EnumMap<HouseNeedType, Integer> needs = new EnumMap(HouseNeedType.class);
    private final HashMap<String, Domain> domains = new HashMap();
    private final HashSet<String> wantedPlayers = new HashSet();
    private Boolean trustInIndirectVassals = false;
    public static final int MAX_NEED_AMOUNT = 4096;

    public House() {
        this.lordUUID = null;
        this.houseTitle = null;
        this.houseColor = null;
        this.houseHP = -1;
        this.players = new HashSet();
    }

    public House(String lordUUID, String houseTitle, String houseColor) {
        this.lordUUID = lordUUID;
        this.houseTitle = houseTitle;
        this.houseColor = houseColor;
        this.houseHP = 1000;
        this.players = new HashSet();
        this.players.add(lordUUID);
    }

    public House(CompoundTag nbt) {
        this();
        this.deserializeNBT(nbt);
    }

    public String getLordUUID() {
        return this.lordUUID;
    }

    public void setLordUUID(String lordUUID) {
        this.lordUUID = lordUUID;
    }

    public String getHouseTitle() {
        return this.houseTitle;
    }

    public void setHouseTitle(String houseTitle) {
        this.houseTitle = houseTitle;
    }

    public String getHouseColor() {
        return this.houseColor;
    }

    public String getHouseTitleWithColor() {
        return HouseManager.getHouseColorCode(this.getHouseColor()) + this.getHouseTitle() + "\u00a7r";
    }

    public void setHouseColor(String houseColor) {
        this.houseColor = houseColor;
    }

    public int getHouseHP() {
        return this.houseHP;
    }

    public void setHouseHP(int houseHP) {
        this.houseHP = Math.min(1000, Math.max(0, houseHP));
    }

    public int addHouseHP(int amount) {
        this.setHouseHP(this.houseHP + amount);
        return this.houseHP;
    }

    public HashSet<String> getPlayers() {
        return this.players;
    }

    public void setPlayers(HashSet<String> players) {
        this.players = players;
    }

    public HashMap<String, Domain> getDomains() {
        return this.domains;
    }

    public int[] getHousePlusCoordinates() {
        return this.housePlusCoordinates;
    }

    public void setHousePlusCoordinates(int[] coordinates) {
        this.housePlusCoordinates = coordinates;
    }

    public int[] getHouseIncubatorCoordinates() {
        return this.houseIncubatorCoordinates;
    }

    public void setHouseIncubatorCoordinates(int[] coordinates) {
        this.houseIncubatorCoordinates = coordinates;
    }

    public int[] getHousePrisonCoordinates() {
        return this.housePrisonCoordinates;
    }

    public void setHousePrisonCoordinates(int[] coordinates) {
        this.housePrisonCoordinates = coordinates;
    }

    public boolean isNull() {
        return Objects.equals(this.lordUUID, null);
    }

    public boolean containsDomain(String domainHeadUUID) {
        return this.domains.containsKey(domainHeadUUID);
    }

    public void emplaceDomain(String knightUUID, Component knightDisplayName) {
        if (this.domains.size() >= this.getHouseLevel()) {
            return;
        }
        this.domains.putIfAbsent(knightUUID, new Domain(this.lordUUID, knightUUID, knightDisplayName));
        this.players.add(knightUUID);
    }

    public void pushDomain(Domain domain) {
        if (this.domains.size() >= this.getHouseLevel()) {
            return;
        }
        this.domains.putIfAbsent(domain.getKnightUUID(), domain);
        this.players.add(domain.getKnightUUID());
    }

    public void removeDomain(String knightUUID) {
        Domain d = this.domains.get(knightUUID);
        if (d != null) {
            ServerLevel serverInstance = HouseSavedData.getServerInstance();
            for (String playerId : d.getPlayers()) {
                Player p;
                if (serverInstance != null && (p = serverInstance.m_46003_(UUID.fromString(playerId))) != null) {
                    ClearHouseProcedure.execute((Entity)p);
                    HouseManager.playerPrefixSynchronize(p);
                }
                this.players.remove(playerId);
            }
        }
        this.domains.remove(knightUUID);
        HouseManager.allPlayersPrefixPacketSend();
    }

    public void pushPlayerToDomain(String knightUUID, String playerUUID) {
        if (this.domains.containsKey(knightUUID)) {
            Domain dom = this.domains.get(knightUUID);
            if (Objects.equals(knightUUID, this.lordUUID) ? dom.getPlayers().size() >= 8 : dom.getPlayers().size() >= 5) {
                return;
            }
            dom.pushPlayer(playerUUID);
            this.players.add(playerUUID);
        }
    }

    public void removePlayerFromDomain(String knightUUID, String playerUUID) {
        if (this.domains.containsKey(knightUUID)) {
            Player p;
            ServerLevel serverInstance = HouseSavedData.getServerInstance();
            if (serverInstance != null && (p = serverInstance.m_46003_(UUID.fromString(playerUUID))) != null) {
                ClearHouseProcedure.execute((Entity)p);
                HouseManager.playerPrefixSynchronize(p);
            }
            this.domains.get(knightUUID).removePlayer(playerUUID);
            this.players.remove(playerUUID);
        }
    }

    public HashSet<String> getWantedPlayers() {
        return this.wantedPlayers;
    }

    public void addWantedPlayer(String playerId) {
        this.wantedPlayers.add(playerId);
        this.getDomains().forEach((k, v) -> v.adjustSuspicionForPlayer(playerId, -100));
    }

    public void removeWantedPlayer(String playerId) {
        this.wantedPlayers.remove(playerId);
    }

    public boolean isWanted(String playerId) {
        return this.wantedPlayers.contains(playerId);
    }

    public int getNeed(HouseNeedType type) {
        return this.needs.getOrDefault((Object)type, 0);
    }

    public void setNeed(HouseNeedType type, int value) {
        this.needs.put(type, Math.min(4096, Math.max(0, value)));
    }

    public int adjustNeed(HouseNeedType type, int delta) {
        int newValue = this.getNeed(type) + delta;
        this.setNeed(type, newValue);
        return this.getNeed(type);
    }

    public int getFreeNeedCapacity(HouseNeedType type) {
        return 4096 - this.getNeed(type);
    }

    public void updateIncubatorInfo() {
        IncubatorUpdateInfoProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance(), this.houseIncubatorCoordinates[0], this.houseIncubatorCoordinates[1], this.houseIncubatorCoordinates[2], this.lordUUID);
    }

    public String getClaimId() {
        return this.claimId;
    }

    public void setClaimId(String claimId) {
        this.claimId = claimId;
        HouseSavedData.getInstance().m_77762_();
    }

    public int getHouseLevel() {
        return Math.min(10, 1 + this.players.size() / 3);
    }

    public boolean canCreateDomain() {
        return this.domains.size() < this.getHouseLevel();
    }

    public Optional<Boolean> getDebuff(String knightUUID, Domain.DomainDebuffs debuff) {
        if (this.domains.containsKey(knightUUID)) {
            return Optional.ofNullable(this.domains.get(knightUUID).getDebuff(debuff));
        }
        return Optional.empty();
    }

    public boolean toggleOnDebuff(String knightUUID, Domain.DomainDebuffs debuff) {
        if (this.domains.containsKey(knightUUID)) {
            this.domains.get(knightUUID).toggleOnDebuff(debuff);
            return true;
        }
        return false;
    }

    public boolean toggleOffDebuff(String knightUUID, Domain.DomainDebuffs debuff) {
        if (this.domains.containsKey(knightUUID)) {
            this.domains.get(knightUUID).toggleOffDebuff(debuff);
            return true;
        }
        return false;
    }

    public boolean isIndirectVassalsBeTrusted() {
        return this.trustInIndirectVassals;
    }

    public void toggleOnIndirectVassalsTrust() {
        this.trustInIndirectVassals = true;
        HouseSavedData.getInstance().m_77762_();
    }

    public void toggleOffIndirectVassalsTrust() {
        this.trustInIndirectVassals = false;
        HouseSavedData.getInstance().m_77762_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("lord_uuid", this.lordUUID);
        tag.m_128359_("house_title", this.houseTitle);
        tag.m_128359_("house_color", this.houseColor);
        tag.m_128405_("house_hp", this.houseHP);
        tag.m_128385_("house_plus_coordinates", this.housePlusCoordinates);
        tag.m_128385_("house_incubator_coordinates", this.houseIncubatorCoordinates);
        tag.m_128385_("house_prison_coordinates", this.housePrisonCoordinates);
        ListTag playersTag = new ListTag();
        for (String string : this.players) {
            playersTag.add((Object)StringTag.m_129297_((String)string));
        }
        tag.m_128365_("players", (Tag)playersTag);
        ListTag domainsTag = new ListTag();
        for (Map.Entry<String, Domain> entry : this.domains.entrySet()) {
            domainsTag.add((Object)entry.getValue().serializeNBT());
        }
        tag.m_128365_("domains", (Tag)domainsTag);
        ListTag listTag = new ListTag();
        for (String w : this.wantedPlayers) {
            listTag.add((Object)StringTag.m_129297_((String)w));
        }
        tag.m_128365_("wanted", (Tag)listTag);
        CompoundTag compoundTag = new CompoundTag();
        for (HouseNeedType type : HouseNeedType.values()) {
            compoundTag.m_128405_(type.name(), this.getNeed(type));
        }
        tag.m_128365_("house_needs", (Tag)compoundTag);
        tag.m_128359_("house_claim_id", this.claimId == null ? "" : this.claimId);
        tag.m_128379_("trust_in_indirect_vassals", this.trustInIndirectVassals.booleanValue());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        String loadedClaim;
        this.lordUUID = nbt.m_128461_("lord_uuid");
        this.houseTitle = nbt.m_128461_("house_title");
        this.houseColor = nbt.m_128461_("house_color");
        this.houseHP = nbt.m_128451_("house_hp");
        this.housePlusCoordinates = nbt.m_128465_("house_plus_coordinates");
        this.houseIncubatorCoordinates = nbt.m_128465_("house_incubator_coordinates");
        this.housePrisonCoordinates = nbt.m_128465_("house_prison_coordinates");
        this.players.clear();
        ListTag playersTag = nbt.m_128437_("players", 8);
        for (int i = 0; i < playersTag.size(); ++i) {
            this.players.add(playersTag.m_128778_(i));
        }
        this.domains.clear();
        ListTag domainsTag = nbt.m_128437_("domains", 10);
        for (int i = 0; i < domainsTag.size(); ++i) {
            CompoundTag domainNBT = domainsTag.m_128728_(i);
            this.pushDomain(new Domain(domainNBT));
        }
        this.wantedPlayers.clear();
        if (nbt.m_128441_("wanted")) {
            ListTag wantedList = nbt.m_128437_("wanted", 8);
            for (int i = 0; i < wantedList.size(); ++i) {
                this.wantedPlayers.add(wantedList.m_128778_(i));
            }
        }
        if (nbt.m_128441_("house_needs")) {
            CompoundTag needsTag = nbt.m_128469_("house_needs");
            for (HouseNeedType type : HouseNeedType.values()) {
                this.setNeed(type, needsTag.m_128451_(type.name()));
            }
        }
        this.claimId = (loadedClaim = nbt.m_128461_("house_claim_id")).isEmpty() ? null : loadedClaim;
        this.trustInIndirectVassals = nbt.m_128471_("trust_in_indirect_vassals");
    }
}

