/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.house;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.mcreator.reignmod.claim.capital.CapitalClaimManager;
import net.mcreator.reignmod.house.Domain;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseNeedType;
import net.mcreator.reignmod.house.HouseSavedData;
import net.mcreator.reignmod.network.ReignModModVariables;
import net.mcreator.reignmod.networking.ReignNetworking;
import net.mcreator.reignmod.networking.packet.S2C.PlayerPrefixSyncS2CPacket;
import net.mcreator.reignmod.procedures.HouseDeleteProcedure;
import net.mcreator.reignmod.procedures.IsKingProcedure;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.UsernameCache;

public class HouseManager {
    private static final HashMap<String, String> colorCodes = HouseManager.fillColorCodes();

    private static HashMap<String, String> fillColorCodes() {
        HashMap<String, String> colorCodes = new HashMap<String, String>();
        List<String> colors = List.of("yellow", "lime", "green", "aqua", "blue", "purple", "pink", "red", "orange", "black");
        List<String> codes = List.of("\u00a7e", "\u00a7a", "\u00a72", "\u00a7b", "\u00a79", "\u00a75", "\u00a7d", "\u00a7c", "\u00a76", "\u00a78");
        Iterator<String> colorsIterator = colors.iterator();
        Iterator<String> codesIterator = codes.iterator();
        while (colorsIterator.hasNext() && codesIterator.hasNext()) {
            colorCodes.put(colorsIterator.next(), codesIterator.next());
        }
        return colorCodes;
    }

    public static Collection<House> getHouses() {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHouses().values();
        }
        return new ArrayList<House>();
    }

    public static Collection<House> getHousesCopies() {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            Collection<House> houses = houseSavedData.getHouseData().getHouses().values();
            ArrayList<House> housesCopies = new ArrayList<House>();
            houses.forEach(house -> housesCopies.add(new House(house.serializeNBT())));
            return housesCopies;
        }
        return new ArrayList<House>();
    }

    public static int getHousesCount() {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHouses().size();
        }
        return 0;
    }

    public static boolean createHouse(Player lordPlayer, String houseTitle, String houseColor) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.addHouse(lordPlayer.m_20149_(), houseTitle, houseColor);
        }
        return false;
    }

    public static boolean createDomain(Player lordPlayer, Player knightPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.addDomain(lordPlayer.m_20149_(), knightPlayer.m_20149_(), knightPlayer.m_5446_().getString());
        }
        return false;
    }

    public static void deleteHouse(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            HouseDeleteProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance(), HouseManager.getHouseByLordUUID(lordUUID).getHouseTitleWithColor());
            houseSavedData.removeHouse(lordUUID);
        }
    }

    public static void deleteDomain(Player lordPlayer, Player knightPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.removeDomain(lordPlayer.m_20149_(), knightPlayer.m_20149_());
        }
    }

    public static boolean pushPlayerToDomain(Player knightPlayer, Player player) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.pushPlayerToDomain(knightPlayer.m_20149_(), player.m_20149_());
        }
        return false;
    }

    public static void removePlayerFromDomain(Player player) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            String suzerainUUID = HouseManager.getPlayerSuzerain(player);
            houseSavedData.removePlayerFromDomain(suzerainUUID, player.m_20149_());
        }
    }

    public static boolean removePlayerFromDomain(String knightUUID, String playerName) {
        UUID found;
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null && (found = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName)) != null) {
            houseSavedData.removePlayerFromDomain(knightUUID, found.toString());
            return true;
        }
        return false;
    }

    public static removeDirectVassalResult removeDirectVassal(String suzerainUUID, String playerName) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            Domain playerDomain;
            Domain foundDomain = houseSavedData.getHouseData().findDomainByKnight(suzerainUUID);
            House foundHouse = houseSavedData.getHouseData().findHouseByLord(suzerainUUID);
            UUID foundPlayerUUID = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName);
            if (foundPlayerUUID == null) {
                return removeDirectVassalResult.PLAYER_NOT_FOUND;
            }
            if (!foundHouse.isNull() && !(playerDomain = houseSavedData.getHouseData().findDomainByKnight(foundPlayerUUID.toString())).isNull() && playerDomain.getLordUUID().equals(suzerainUUID)) {
                if (playerDomain.getClaimId() != null) {
                    return removeDirectVassalResult.DOMAIN_IS_PROTECTED;
                }
                houseSavedData.removeDomain(suzerainUUID, foundPlayerUUID.toString());
                return removeDirectVassalResult.SUCCESS;
            }
            if (!foundDomain.isNull() && foundDomain.getPlayers().contains(foundPlayerUUID.toString())) {
                houseSavedData.removePlayerFromDomain(suzerainUUID, foundPlayerUUID.toString());
                return removeDirectVassalResult.SUCCESS;
            }
        }
        return removeDirectVassalResult.INSUFFICIENT_AUTHORITY;
    }

    public static boolean addWantedPlayer(String lordUUID, String playerName) {
        UUID found;
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null && (found = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName)) != null) {
            houseSavedData.addWantedPlayer(lordUUID, found.toString());
            return true;
        }
        return false;
    }

    public static boolean removeWantedPlayer(String lordUUID, String playerName) {
        UUID found;
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null && (found = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName)) != null) {
            houseSavedData.removeWantedPlayer(lordUUID, found.toString());
            return true;
        }
        return false;
    }

    public static boolean isPlayerLord(Player lordPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return !houseSavedData.getHouseData().findHouseByLord(lordPlayer.m_20149_()).isNull();
        }
        return false;
    }

    public static boolean isPlayerKnight(Player knightPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return !houseSavedData.getHouseData().findDomainByKnight(knightPlayer.m_20149_()).isNull();
        }
        return false;
    }

    public static boolean isColorAvailable(String color) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.isColorAvailable(color);
        }
        return false;
    }

    public static House getHouseByLordUUID(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().findHouseByLord(lordUUID);
        }
        return new House();
    }

    public static Domain getDomainByKnightUUID(String knightUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().findDomainByKnight(knightUUID);
        }
        return new Domain();
    }

    public static String getPlayerSuzerain(Player player) {
        return ((ReignModModVariables.PlayerVariables)player.getCapability(ReignModModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new ReignModModVariables.PlayerVariables())).house;
    }

    public static String getPlayerDisplayName(Player player) {
        String displayNameWithPrefix = player.m_5446_().getString();
        int playerNameLength = player.m_7755_().getString().length();
        return displayNameWithPrefix.substring(displayNameWithPrefix.length() - playerNameLength);
    }

    public static void playerPrefixSynchronize(Player player) {
        Object colorPrefix = HouseManager.getPlayerHouseColorCode(player);
        if (!Objects.equals(colorPrefix, "")) {
            if (IsKingProcedure.execute((LevelAccessor)player.m_20193_(), (Entity)player)) {
                colorPrefix = "\u00a7r[\u00a76\ud83d\udc51\u00a7r] " + (String)colorPrefix + "\u00a7l";
            } else if (HouseManager.isPlayerLord(player)) {
                colorPrefix = "\u00a7r[" + (String)colorPrefix + "\ud83c\udff0\u00a7r] " + (String)colorPrefix + "\u00a7l";
            } else if (HouseManager.isPlayerKnight(player)) {
                colorPrefix = "\u00a7r[" + (String)colorPrefix + "\ud83d\udde1\u00a7r] " + (String)colorPrefix;
            }
        }
        String finalPlayerPrefix = colorPrefix;
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        houseSavedData.getHouseData().addOrUpdatePlayerCode(player.m_20149_(), finalPlayerPrefix);
        player.getCapability(ReignModModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.player_prefix = finalPlayerPrefix;
            capability.syncPlayerVariables((Entity)player);
        });
        if (player instanceof ServerPlayer) {
            ReignNetworking.sendToPlayer(new PlayerPrefixSyncS2CPacket(houseSavedData.getHouseData().getPlayerCodes()), (ServerPlayer)player);
        }
        player.refreshDisplayName();
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).refreshTabListName();
        }
    }

    public static void allPlayersPrefixPacketSend() {
        ServerLevel serverInstance = HouseSavedData.getServerInstance();
        serverInstance.m_8795_(serverPlayer -> true).forEach(serverPlayer -> {
            HouseSavedData houseSavedData = HouseSavedData.getInstance();
            ReignNetworking.sendToPlayer(new PlayerPrefixSyncS2CPacket(houseSavedData.getHouseData().getPlayerCodes()), serverPlayer);
        });
    }

    public static House getPlayerHouse(Player player) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            String suzerainUUID = HouseManager.getPlayerSuzerain(player);
            return houseSavedData.getPlayerHouse(suzerainUUID);
        }
        return new House();
    }

    public static House getHouseBySuzerainUUID(String suzerainUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return HouseSavedData.getInstance().getHouseData().findHouseByPlayerSuzerain(suzerainUUID);
        }
        return new House();
    }

    public static String getPlayerHouseTitle(Player player) {
        return HouseManager.getPlayerHouse(player).getHouseTitle();
    }

    public static String getPlayerHouseColor(Player player) {
        return HouseManager.getPlayerHouse(player).getHouseColor();
    }

    public static String getPlayerHouseColorCode(Player player) {
        return colorCodes.getOrDefault(HouseManager.getPlayerHouseColor(player), "");
    }

    public static String getHouseColorCode(String color) {
        return colorCodes.getOrDefault(color, "");
    }

    public static String getPlayerHouseLord(Player player) {
        return HouseManager.getPlayerHouse(player).getLordUUID();
    }

    public static int getHouseDomainCount(Player player) {
        return HouseManager.getPlayerHouse(player).getDomains().size();
    }

    public static int getHousePlayerCount(Player player) {
        return HouseManager.getPlayerHouse(player).getPlayers().size();
    }

    public static ArrayList<String> getHouseWantedPlayers(ServerPlayer serverPlayer) {
        HashSet<String> found = HouseManager.getPlayerHouse((Player)serverPlayer).getWantedPlayers();
        ArrayList<String> domainWantedPlayers = new ArrayList<String>(found.size());
        found.forEach(sus -> domainWantedPlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(sus, "") + HouseManager.getOfflinePlayerName(sus)));
        return domainWantedPlayers;
    }

    public static Domain getPlayerDomain(Player player) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            String suzerainUUID = HouseManager.getPlayerSuzerain(player);
            return houseSavedData.getPlayerDomain(player.m_20149_(), suzerainUUID);
        }
        return new Domain();
    }

    public static String getDomainLordByKnight(String knightUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().findDomainByKnight(knightUUID).getLordUUID();
        }
        return null;
    }

    public static String getPlayerDomainTitle(Player player) {
        return HouseManager.getPlayerDomain(player).getDomainTitle().getString();
    }

    public static String getPlayerDomainKnight(Player player) {
        return HouseManager.getPlayerDomain(player).getKnightUUID();
    }

    public static int getDomainPlayerCount(Player player) {
        return HouseManager.getPlayerDomain(player).getPlayers().size();
    }

    public static int getDomainCount() {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getDomains().size();
        }
        return -1;
    }

    public static ArrayList<String> getDomainPlayers(String knightUUID) {
        HashSet<String> found = HouseManager.getDomainByKnightUUID(knightUUID).getPlayers();
        ArrayList<String> domainPlayers = new ArrayList<String>(found.size());
        found.forEach(sus -> domainPlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(sus, "") + HouseManager.getOfflinePlayerName(sus)));
        return domainPlayers;
    }

    public static ArrayList<String> getDomainSuspectPlayers(String knightUUID, int count) {
        List<Map.Entry<String, Integer>> found = HouseManager.getDomainByKnightUUID(knightUUID).getSortedSuspects(count);
        ArrayList<String> domainSuspectPlayers = new ArrayList<String>(found.size());
        found.forEach(sus -> domainSuspectPlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(sus.getKey(), "") + HouseManager.getOfflinePlayerName((String)sus.getKey()) + "\u00a7r: " + sus.getValue()));
        return domainSuspectPlayers;
    }

    public static ArrayList<String> getIlyaDomainSuspectPlayers(String knightUUID, int count) {
        List<Map.Entry<String, Integer>> found = HouseManager.getDomainByKnightUUID(knightUUID).getSortedSuspects(count);
        ArrayList<String> domainSuspectPlayers = new ArrayList<String>(found.size());
        found.forEach(sus -> {
            domainSuspectPlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(sus.getKey(), "") + HouseManager.getOfflinePlayerName((String)sus.getKey()));
            domainSuspectPlayers.add(String.valueOf(sus.getValue()));
        });
        while (domainSuspectPlayers.size() < count * 2) {
            domainSuspectPlayers.add("");
        }
        return domainSuspectPlayers;
    }

    public Optional<Boolean> getDomainDebuff(String lordUUID, String knightUUID, Domain.DomainDebuffs debuff) {
        return HouseManager.getHouseByLordUUID(lordUUID).getDebuff(knightUUID, debuff);
    }

    public boolean toggleOnDebuff(String lordUUID, String knightUUID, Domain.DomainDebuffs debuff) {
        return HouseManager.getHouseByLordUUID(lordUUID).toggleOnDebuff(knightUUID, debuff);
    }

    public boolean toggleOffDebuff(String lordUUID, String knightUUID, Domain.DomainDebuffs debuff) {
        return HouseManager.getHouseByLordUUID(lordUUID).toggleOffDebuff(knightUUID, debuff);
    }

    private static int[] getHousePlusCoordinates(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHousePlusCoordinates(lordUUID);
        }
        return new int[]{0, 0, 0};
    }

    public static boolean isHousePlusNull(String lordUUID) {
        return Arrays.equals(HouseManager.getHousePlusCoordinates(lordUUID), new int[]{0, 0, 0});
    }

    public static int getHousePlusX(String lordUUID) {
        return HouseManager.getHousePlusCoordinates(lordUUID)[0];
    }

    public static int getHousePlusY(String lordUUID) {
        return HouseManager.getHousePlusCoordinates(lordUUID)[1];
    }

    public static int getHousePlusZ(String lordUUID) {
        return HouseManager.getHousePlusCoordinates(lordUUID)[2];
    }

    public static void setHousePlusCoordinates(String lordUUID, int x, int y, int z) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.getHouseData().setHousePlusCoordinates(lordUUID, x, y, z);
            houseSavedData.m_77762_();
        }
    }

    private static int[] getHouseIncubatorCoordinates(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHouseIncubatorCoordinates(lordUUID);
        }
        return new int[]{0, 0, 0};
    }

    public static boolean isHouseIncubatorNull(String lordUUID) {
        return Arrays.equals(HouseManager.getHouseIncubatorCoordinates(lordUUID), new int[]{0, 0, 0});
    }

    public static int getHouseIncubatorX(String lordUUID) {
        return HouseManager.getHouseIncubatorCoordinates(lordUUID)[0];
    }

    public static int getHouseIncubatorY(String lordUUID) {
        return HouseManager.getHouseIncubatorCoordinates(lordUUID)[1];
    }

    public static int getHouseIncubatorZ(String lordUUID) {
        return HouseManager.getHouseIncubatorCoordinates(lordUUID)[2];
    }

    public static void setHouseIncubatorCoordinates(String lordUUID, int x, int y, int z) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.getHouseData().setHouseIncubatorCoordinates(lordUUID, x, y, z);
            houseSavedData.m_77762_();
        }
    }

    private static int[] getHousePrisonCoordinates(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHousePrisonCoordinates(lordUUID);
        }
        return new int[]{0, 0, 0};
    }

    public static boolean isHousePrisonNull(String lordUUID) {
        return Arrays.equals(HouseManager.getHousePrisonCoordinates(lordUUID), new int[]{0, 0, 0});
    }

    public static int getHousePrisonX(String lordUUID) {
        return HouseManager.getHousePrisonCoordinates(lordUUID)[0];
    }

    public static int getHousePrisonY(String lordUUID) {
        return HouseManager.getHousePrisonCoordinates(lordUUID)[1];
    }

    public static int getHousePrisonZ(String lordUUID) {
        return HouseManager.getHousePrisonCoordinates(lordUUID)[2];
    }

    public void setHousePrisonCoordinates(String lordUUID, int x, int y, int z) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.getHouseData().setHousePrisonCoordinates(lordUUID, x, y, z);
            houseSavedData.m_77762_();
        }
    }

    public static int getHouseNeed(ServerPlayer player, HouseNeedType type) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        return houseSavedData.getHouseNeed(player.m_20149_(), type);
    }

    public static void setHouseNeed(ServerPlayer player, HouseNeedType type, int value) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        houseSavedData.setHouseNeed(player.m_20149_(), type, value);
    }

    public static int adjustHouseNeed(ServerPlayer player, HouseNeedType type, int delta) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        return houseSavedData.adjustHouseNeed(player.m_20149_(), type, delta);
    }

    public static void feedHouses() {
        ArrayList<String> houses_to_delete = new ArrayList<String>();
        Collection<House> houses = HouseManager.getHouses();
        for (House house : houses) {
            int need_jewelry;
            Collection<Domain> domains = house.getDomains().values();
            int lvl = house.getHouseLevel();
            int add_hp = -70 - lvl * 12;
            if (house.getPlayers().size() < 3) {
                add_hp -= 100;
            }
            int need_fuel = domains.size() * 2 + 4;
            int need_bread = house.getPlayers().size() + 1;
            int need_roots = lvl >= 3 ? house.getPlayers().size() : 0;
            int need_meat = lvl >= 4 ? domains.size() : 0;
            int need_wool = lvl >= 5 ? domains.size() : 0;
            int need_sweets = lvl >= 6 ? 2 : 0;
            int n = need_jewelry = lvl >= 7 ? 2 : 0;
            if (house.getNeed(HouseNeedType.FUEL) >= need_fuel) {
                add_hp += 50;
            }
            house.adjustNeed(HouseNeedType.FUEL, -need_fuel);
            if (house.getNeed(HouseNeedType.BREAD) >= need_bread) {
                add_hp += 50;
            }
            house.adjustNeed(HouseNeedType.BREAD, -need_bread);
            if (house.getNeed(HouseNeedType.ROOTS) >= need_roots && lvl >= 3) {
                add_hp += 20;
            }
            house.adjustNeed(HouseNeedType.ROOTS, -need_roots);
            if (house.getNeed(HouseNeedType.MEAT) >= need_meat && lvl >= 4) {
                add_hp += 20;
            }
            house.adjustNeed(HouseNeedType.MEAT, -need_meat);
            if (house.getNeed(HouseNeedType.WOOL) >= need_wool && lvl >= 5) {
                add_hp += 10;
            }
            house.adjustNeed(HouseNeedType.WOOL, -need_wool);
            if (house.getNeed(HouseNeedType.SWEETS) >= need_sweets && lvl >= 6) {
                add_hp += 10;
            }
            house.adjustNeed(HouseNeedType.SWEETS, -need_sweets);
            if (house.getNeed(HouseNeedType.JEWELRY) >= need_jewelry && lvl >= 7) {
                add_hp += 10;
            }
            house.adjustNeed(HouseNeedType.JEWELRY, -need_jewelry);
            int add_from_domains = 0;
            for (Domain domain : domains) {
                domain.adjustSuspicionForAll(-1);
                HouseManager.damageDomain(domain);
                HouseManager.chanceDomainEvents(domain);
                add_from_domains += 3 * (domain.getDomainHP() / 300);
            }
            if (house.addHouseHP(Math.max(-40, Math.min(add_hp += add_from_domains, 40))) == 0) {
                houses_to_delete.add(house.getLordUUID());
            }
            HouseSavedData.getInstance().m_77762_();
            house.updateIncubatorInfo();
        }
        houses_to_delete.forEach(HouseManager::deleteHouse);
    }

    private static void damageDomain(Domain domain) {
        int add = 2;
        if (domain.getDebuff(Domain.DomainDebuffs.disease).booleanValue()) {
            add -= 4;
        }
        if (domain.getDebuff(Domain.DomainDebuffs.robbers).booleanValue()) {
            add -= 7;
        }
        domain.addDomainHP(add);
    }

    private static void chanceDomainEvents(Domain domain) {
        int x = (int)(Math.random() * 1000.0) + 1;
        if (x == 1) {
            domain.toggleOnDebuff(Domain.DomainDebuffs.robbers);
        }
        if ((x = (int)(Math.random() * 100.0) + 1) == 1) {
            domain.toggleOffDebuff(Domain.DomainDebuffs.disease);
        }
    }

    public static String getOfflinePlayerName(String playerUUID) {
        String playerName = UsernameCache.getLastKnownUsername((UUID)UUID.fromString(playerUUID));
        if (playerName != null) {
            return playerName;
        }
        return "";
    }

    public static enum removeDirectVassalResult {
        PLAYER_NOT_FOUND,
        INSUFFICIENT_AUTHORITY,
        DOMAIN_IS_PROTECTED,
        SUCCESS;

    }
}

