/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.kingdom;

import java.util.Map;
import net.mcreator.reignmod.basics.ReignSavedData;
import net.mcreator.reignmod.kingdom.KingdomData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;

public class KingdomSavedData
extends ReignSavedData {
    private final KingdomData kingdomData = new KingdomData();
    private static KingdomSavedData instance;

    public KingdomSavedData() {
    }

    public KingdomSavedData(CompoundTag tag) {
        this.loadFromNBT(tag);
    }

    @Override
    protected String getDataKey() {
        return "kingdom_data";
    }

    public static void initialize(ServerLevel serverLevel) {
        if (instance == null) {
            instance = (KingdomSavedData)serverLevel.m_8895_().m_164861_(KingdomSavedData::new, KingdomSavedData::new, "kingdom_data");
            KingdomSavedData.instance.serverLevelInstance = serverLevel;
        }
    }

    public static void resetInstance() {
        instance = null;
    }

    public static KingdomSavedData getInstance() {
        if (instance == null) {
            throw new IllegalStateException("KingdomSavedData is not initialized!");
        }
        return instance;
    }

    public KingdomData getKingdomData() {
        return this.kingdomData;
    }

    public static ServerLevel getServerInstance() {
        return KingdomSavedData.getInstance().getServerLevelInstance();
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        tag.m_128405_("capital_era", this.getKingdomData().getCapitalEra());
        tag.m_128405_("capital_discontent", this.getKingdomData().getCapitalDiscontent());
        tag.m_128405_("source_disturbance", this.getKingdomData().getSourceDisturbance());
        tag.m_128385_("fund_coordinates", this.getKingdomData().getFundCoordinates());
        tag.m_128385_("coffers_coordinates", this.getKingdomData().getCoffersCoordinates());
        tag.m_128385_("prison_coordinates", this.getKingdomData().getPrisonCoordinates());
        CompoundTag courtTag = new CompoundTag();
        for (Map.Entry<KingdomData.CourtPosition, String> entry : this.getKingdomData().getAllCourtiers().entrySet()) {
            if (entry.getValue() == null) continue;
            courtTag.m_128359_(entry.getKey().name(), entry.getValue());
        }
        tag.m_128365_("court_positions", (Tag)courtTag);
        return tag;
    }

    private void loadFromNBT(CompoundTag tag) {
        this.getKingdomData().setCapitalEra(tag.m_128451_("capital_era"));
        this.getKingdomData().setCapitalDiscontent(tag.m_128451_("capital_discontent"));
        this.getKingdomData().setSourceDisturbance(tag.m_128451_("source_disturbance"));
        int[] fundCoordinates = tag.m_128465_("fund_coordinates");
        int[] coffersCoordinates = tag.m_128465_("coffers_coordinates");
        int[] prisonCoordinates = tag.m_128465_("prison_coordinates");
        this.getKingdomData().setFundCoordinates(fundCoordinates[0], fundCoordinates[1], fundCoordinates[2]);
        this.getKingdomData().setCoffersCoordinates(coffersCoordinates[0], coffersCoordinates[1], coffersCoordinates[2]);
        this.getKingdomData().setPrisonCoordinates(prisonCoordinates[0], prisonCoordinates[1], prisonCoordinates[2]);
        if (tag.m_128441_("court_positions")) {
            CompoundTag courtTag = tag.m_128469_("court_positions");
            for (String key : courtTag.m_128431_()) {
                KingdomData.CourtPosition pos = KingdomData.CourtPosition.valueOf(key);
                this.getKingdomData().assignCourtier(pos, courtTag.m_128461_(key));
            }
        }
    }
}

