/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.mixins;

import net.mcreator.reignmod.house.HouseManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChestBlock.class})
public class ChestLockMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void blockChestAccess(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof ChestBlockEntity) {
            ChestBlockEntity neighborChest;
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            if (this.isChestLocked(chest, player, level, pos)) {
                cir.setReturnValue((Object)InteractionResult.FAIL);
                return;
            }
            BlockEntity connectedChest = this.getConnectedChest(level, state, pos);
            if (connectedChest instanceof ChestBlockEntity && this.isChestLocked(neighborChest = (ChestBlockEntity)connectedChest, player, level, pos)) {
                cir.setReturnValue((Object)InteractionResult.FAIL);
            }
        }
    }

    private boolean isChestLocked(ChestBlockEntity chest, Player player, Level level, BlockPos pos) {
        CompoundTag tag = chest.getPersistentData();
        if (tag.m_128441_("owner")) {
            String owner = tag.m_128461_("owner");
            String ownerName = tag.m_128461_("owner_name");
            String lock_type = tag.m_128461_("lock_type");
            if (!owner.isEmpty() && !this.canOpen(player, owner, lock_type)) {
                level.m_5594_(null, pos, SoundEvents.f_12626_, SoundSource.BLOCKS, 0.5f, 1.0f);
                player.m_5661_((Component)Component.m_237115_((String)"translation.key.locked").m_130946_(" " + ownerName), true);
                return true;
            }
        }
        return false;
    }

    private boolean canOpen(Player player, String owner, String lock_type) {
        return switch (lock_type) {
            case "personal" -> player.m_20149_().equals(owner);
            case "domain" -> {
                if (player.m_20149_().equals(owner) || HouseManager.getDomainLordByKnight(owner).equals(player.m_20149_()) || HouseManager.getPlayerDomainKnight(player).equals(owner)) {
                    yield true;
                }
                yield false;
            }
            case "house" -> HouseManager.getPlayerHouseLord(player).equals(owner);
            default -> false;
        };
    }

    private BlockEntity getConnectedChest(Level level, BlockState state, BlockPos pos) {
        if (state.m_60734_() instanceof ChestBlock) {
            Direction offsetDirection;
            BlockPos neighborPos;
            BlockState neighborState;
            ChestType chestType = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
            Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
            if (chestType != ChestType.SINGLE && (neighborState = level.m_8055_(neighborPos = pos.m_121945_(offsetDirection = chestType == ChestType.LEFT ? facing.m_122427_() : facing.m_122428_()))).m_60734_() instanceof ChestBlock && neighborState.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
                return level.m_7702_(neighborPos);
            }
        }
        return null;
    }
}

