/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.chunk;

import java.util.Objects;
import java.util.Optional;
import net.mcreator.reignmod.claim.chunk.ChunkClaimManager;
import net.mcreator.reignmod.claim.chunk.ChunkClaimSavedData;
import net.mcreator.reignmod.claim.chunk.ClaimData;
import net.mcreator.reignmod.house.Domain;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.house.HouseSavedData;
import net.mcreator.reignmod.init.ReignModModBlocks;
import net.mcreator.reignmod.init.ReignModModMobEffects;
import net.mcreator.reignmod.network.ReignModModVariables;
import net.mcreator.reignmod.networking.ClientPlayerData;
import net.mcreator.reignmod.networking.ReignNetworking;
import net.mcreator.reignmod.networking.packet.C2S.ChunkBreakPermissionQueryC2SPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorStandItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reign_mod")
public class ChunkClaimProtectionHandler {
    private static final float BLOCK_BREAK_MULTIPLIER = 25.0f;

    public static void increaseSuspicion(ServerPlayer sp, SuspiciousAction susAction, Block block, BlockPos blockPos) {
        int suspicion = ChunkClaimProtectionHandler.getSuspicionByBlock(susAction, block);
        if (suspicion > 0) {
            House chunkHouse;
            Optional<ClaimData> claimOpt = ChunkClaimSavedData.getInstance().getClaimByChunk(new ChunkPos(blockPos).m_45588_());
            if (claimOpt.isEmpty()) {
                return;
            }
            ClaimData claimData = claimOpt.get();
            Domain chunkDomain = HouseManager.getDomainByKnightUUID(claimData.getOwnerId());
            sp.m_5661_(Component.m_130674_((String)(String.valueOf(ChatFormatting.RED) + "\u0412\u044b \u0432\u0435\u0434\u0435\u0442\u0435 \u0441\u0435\u0431\u044f \u043f\u043e\u0434\u043e\u0437\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u043e!")), true);
            if (!(chunkDomain.isNull() || (chunkHouse = HouseManager.getHouseByLordUUID(chunkDomain.getLordUUID())).isNull() || chunkHouse.isWanted(sp.m_20149_()))) {
                chunkDomain.adjustSuspicionForPlayer(sp.m_20149_(), suspicion);
                HouseSavedData.getInstance().m_77762_();
            }
        }
    }

    @SubscribeEvent
    public static void onServerBreakSpeed(PlayerEvent.BreakSpeed event) {
        ServerPlayer sp;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer) || !(sp = (ServerPlayer)player).m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        BlockPos pos = event.getPosition().orElse(null);
        if (pos == null) {
            return;
        }
        if (!ChunkClaimManager.hasPermission(sp, pos)) {
            ReignModModVariables.PlayerVariables caps = (ReignModModVariables.PlayerVariables)sp.getCapability(ReignModModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new ReignModModVariables.PlayerVariables());
            int multiplier = caps.house.isEmpty() ? 3 : 1;
            event.setNewSpeed(event.getNewSpeed() / (25.0f * (float)multiplier));
        }
    }

    @SubscribeEvent
    public static void onServerBreakBlock(BlockEvent.BreakEvent event) {
        ServerPlayer sp;
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer) || !(sp = (ServerPlayer)player).m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        BlockPos pos = event.getPos();
        if (pos == null) {
            return;
        }
        if (!sp.m_7500_() && sp.m_21023_((MobEffect)ReignModModMobEffects.SUSPECT.get())) {
            ChunkClaimProtectionHandler.cancelEvent((Event)event);
            return;
        }
        if (!ChunkClaimManager.hasPermission(sp, pos)) {
            ReignModModVariables.PlayerVariables caps = (ReignModModVariables.PlayerVariables)sp.getCapability(ReignModModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new ReignModModVariables.PlayerVariables());
            int duration = caps.house.isEmpty() ? 300 : 100;
            ChunkClaimProtectionHandler.increaseSuspicion(sp, SuspiciousAction.BLOCK_BREAK, event.getState().m_60734_(), event.getPos());
            sp.m_7292_(new MobEffectInstance((MobEffect)ReignModModMobEffects.SUSPECT.get(), duration, 0, false, false, true));
            sp.m_7292_(new MobEffectInstance(MobEffects.f_19613_, duration, 0, false, false, true));
        }
    }

    @SubscribeEvent
    public static void onServerAttackDecorativeEntity(AttackEntityEvent event) {
        BlockPos pos;
        ServerPlayer sp;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer) || !(sp = (ServerPlayer)player).m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        Entity target = event.getTarget();
        if ((target instanceof HangingEntity || target instanceof ArmorStand) && !ChunkClaimManager.hasPermission(sp, pos = target.m_20183_())) {
            ChunkClaimProtectionHandler.increaseSuspicion(sp, SuspiciousAction.BLOCK_BREAK, Blocks.f_50016_, pos);
        }
    }

    @SubscribeEvent
    public static void onServerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block blockToReport;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ServerLevel level = sp.m_284548_();
        if (!level.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        Item targetItem = event.getItemStack().m_41720_();
        BlockPos pos = event.getPos().m_121945_(Objects.requireNonNull(event.getFace()));
        if (!level.m_6857_().m_61937_(pos)) {
            return;
        }
        if (!level.m_8055_(pos).m_247087_()) {
            return;
        }
        if (targetItem instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)targetItem;
            blockToReport = blockItem.m_40614_();
        } else if (targetItem instanceof HangingEntityItem || targetItem instanceof ArmorStandItem) {
            blockToReport = Blocks.f_50016_;
        } else if (targetItem instanceof BucketItem) {
            blockToReport = Blocks.f_49990_;
        } else if (targetItem instanceof ShovelItem) {
            blockToReport = Blocks.f_152481_;
        } else {
            return;
        }
        BlockState toPlace = blockToReport.m_49966_();
        if (!toPlace.m_60710_((LevelReader)level, pos)) {
            return;
        }
        if (!level.m_45752_(toPlace, pos, CollisionContext.m_82750_((Entity)sp))) {
            return;
        }
        if (!sp.m_7500_() && sp.m_21023_((MobEffect)ReignModModMobEffects.SUSPECT.get())) {
            ChunkClaimProtectionHandler.cancelEvent((Event)event);
            return;
        }
        if (!ChunkClaimManager.hasPermission(sp, pos)) {
            ReignModModVariables.PlayerVariables caps = (ReignModModVariables.PlayerVariables)sp.getCapability(ReignModModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new ReignModModVariables.PlayerVariables());
            int duration = caps.house.isEmpty() ? 600 : 200;
            ChunkClaimProtectionHandler.increaseSuspicion(sp, SuspiciousAction.BLOCK_PLACE, blockToReport, pos);
            sp.m_7292_(new MobEffectInstance((MobEffect)ReignModModMobEffects.SUSPECT.get(), duration, 0, false, false, true));
        }
    }

    @SubscribeEvent
    public static void onServerEnteringSection(EntityEvent.EnteringSection event) {
        ServerPlayer sp;
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer) || !(sp = (ServerPlayer)entity).m_9236_().m_46472_().equals((Object)Level.f_46428_) || ModList.get().isLoaded("openpartiesandclaims")) {
            return;
        }
        Optional<String> oldOwnerData = ChunkClaimManager.getChunkOwnerName(SectionPos.m_123184_((long)event.getPackedOldPos()).m_123251_());
        Optional<String> newOwnerData = ChunkClaimManager.getChunkOwnerName(SectionPos.m_123184_((long)event.getPackedNewPos()).m_123251_());
        if (oldOwnerData.isPresent() && newOwnerData.isPresent()) {
            String newOwner;
            String oldOwner = oldOwnerData.get();
            if (!Objects.equals(oldOwner, newOwner = newOwnerData.get())) {
                sp.m_5661_(Component.m_130674_((String)newOwner), true);
            }
        } else if (newOwnerData.isPresent()) {
            String owner = newOwnerData.get();
            sp.m_5661_(Component.m_130674_((String)owner), true);
        } else if (oldOwnerData.isPresent()) {
            sp.m_5661_(Component.m_130674_((String)(String.valueOf(ChatFormatting.GREEN) + "\u041d\u0438\u0447\u0435\u0439\u043d\u044b\u0435 \u0437\u0435\u043c\u043b\u0438")), true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockPos pos;
        LocalPlayer lp;
        Player player = event.getEntity();
        if (!(player instanceof LocalPlayer) || !(lp = (LocalPlayer)player).m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        if (!lp.m_7500_() && lp.m_21023_((MobEffect)ReignModModMobEffects.SUSPECT.get())) {
            ChunkClaimProtectionHandler.cancelEvent((Event)event);
        }
        if ((pos = (BlockPos)event.getPosition().orElse(null)) == null) {
            return;
        }
        ChunkPos cp = new ChunkPos(pos);
        if (ClientPlayerData.isLastKnownChunkEmpty()) {
            ReignNetworking.sendToServer(new ChunkBreakPermissionQueryC2SPacket(cp.f_45578_, cp.f_45579_));
        }
        if (ClientPlayerData.isLastKnownChunk(cp.f_45578_, cp.f_45579_) && !ClientPlayerData.isLastKnownChunkAvailable()) {
            ReignModModVariables.PlayerVariables caps = (ReignModModVariables.PlayerVariables)lp.getCapability(ReignModModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new ReignModModVariables.PlayerVariables());
            int multiplier = caps.house.isEmpty() ? 3 : 1;
            event.setNewSpeed(event.getNewSpeed() / (25.0f * (float)multiplier));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer lp = (LocalPlayer)player;
        if (!lp.m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        if (!lp.m_7500_() && lp.m_21023_((MobEffect)ReignModModMobEffects.SUSPECT.get())) {
            ChunkClaimProtectionHandler.cancelEvent((Event)event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block blockToReport;
        Player player = event.getEntity();
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer lp = (LocalPlayer)player;
        ClientLevel level = lp.f_108545_;
        BlockPos pos = event.getPos().m_121945_(Objects.requireNonNull(event.getFace()));
        if (!level.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        if (!level.m_6857_().m_61937_(pos)) {
            return;
        }
        if (!level.m_8055_(pos).m_247087_()) {
            return;
        }
        Item targetItem = event.getItemStack().m_41720_();
        if (targetItem instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)targetItem;
            blockToReport = blockItem.m_40614_();
        } else if (targetItem instanceof HangingEntityItem || targetItem instanceof ArmorStandItem) {
            blockToReport = Blocks.f_50016_;
        } else if (targetItem instanceof BucketItem) {
            blockToReport = Blocks.f_49990_;
        } else if (targetItem instanceof ShovelItem) {
            blockToReport = Blocks.f_152481_;
        } else {
            return;
        }
        BlockState toPlace = blockToReport.m_49966_();
        if (!toPlace.m_60710_((LevelReader)level, pos)) {
            return;
        }
        if (!level.m_45752_(toPlace, pos, CollisionContext.m_82750_((Entity)lp))) {
            return;
        }
        if (!lp.m_7500_() && lp.m_21023_((MobEffect)ReignModModMobEffects.SUSPECT.get())) {
            ChunkClaimProtectionHandler.cancelEvent((Event)event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientEnteringSection(EntityEvent.EnteringSection event) {
        if (event.getEntity() instanceof LocalPlayer) {
            ClientPlayerData.setLastKnownChunk();
            ClientPlayerData.setLastKnownBlock();
            ClientPlayerData.setLastKnownDoor();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientPlayerLogout(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientPlayerData.setLastKnownChunk();
        ClientPlayerData.setLastKnownBlock();
        ClientPlayerData.setLastKnownDoor();
    }

    private static void cancelEvent(Event event) {
        PlayerInteractEvent.RightClickBlock rc;
        if (event.isCancelable()) {
            event.setCanceled(true);
        }
        if (event instanceof PlayerInteractEvent.RightClickBlock) {
            rc = (PlayerInteractEvent.RightClickBlock)event;
            rc.setUseItem(Event.Result.DENY);
            rc.setUseBlock(Event.Result.DENY);
            rc.setCancellationResult(InteractionResult.FAIL);
        }
        if (event instanceof PlayerInteractEvent.RightClickItem) {
            rc = (PlayerInteractEvent.RightClickItem)event;
            rc.setCancellationResult(InteractionResult.FAIL);
        }
    }

    private static int getSuspicionByBlock(SuspiciousAction susAction, Block block) {
        int placeSuspicion = 5;
        int breakSuspicion = 10;
        if (block instanceof BushBlock || block instanceof DirtPathBlock || block instanceof SnowLayerBlock) {
            placeSuspicion = 1;
            breakSuspicion = 1;
        } else if (block instanceof ChestBlock || block instanceof BarrelBlock || block instanceof DoorBlock) {
            placeSuspicion = 10;
            breakSuspicion = 50;
        } else if (block == Blocks.f_50077_) {
            placeSuspicion = 50;
            breakSuspicion = 5;
        } else if (block == Blocks.f_49991_ || block == Blocks.f_49990_) {
            placeSuspicion = 20;
            breakSuspicion = 0;
        } else if (block == ReignModModBlocks.STRATEGY_BLOCK.get()) {
            breakSuspicion = 100;
        }
        return susAction == SuspiciousAction.BLOCK_PLACE ? placeSuspicion : breakSuspicion;
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.register(ChunkClaimProtectionHandler.class);
    }

    public static enum SuspiciousAction {
        BLOCK_BREAK,
        BLOCK_PLACE;

    }
}

