/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.house;

import java.util.Iterator;
import net.mcreator.reignmod.basics.ReignSavedData;
import net.mcreator.reignmod.house.Domain;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseData;
import net.mcreator.reignmod.house.HouseNeedType;
import net.mcreator.reignmod.procedures.ReturnPlusProcedure;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class HouseSavedData
extends ReignSavedData {
    private final HouseData houseData = new HouseData();
    private static HouseSavedData instance;

    public HouseSavedData() {
    }

    public HouseSavedData(CompoundTag compoundTag) {
        ListTag housesTag = compoundTag.m_128437_("houses", 10);
        housesTag.forEach(houseTag -> this.houseData.pushHouse(new House((CompoundTag)houseTag)));
        this.houseData.getDomains().clear();
        this.houseData.getHouses().values().forEach(house -> house.getDomains().values().forEach(this.houseData::addDomain));
        ListTag playersListTag = compoundTag.m_128437_("players", 8);
        ListTag playersCodesListTag = compoundTag.m_128437_("player_codes", 8);
        Iterator i1 = playersListTag.iterator();
        Iterator i2 = playersCodesListTag.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            this.houseData.addOrUpdatePlayerCode(((Tag)i1.next()).m_7916_(), ((Tag)i2.next()).m_7916_());
        }
    }

    public static void initialize(ServerLevel serverLevel) {
        if (instance == null) {
            instance = (HouseSavedData)serverLevel.m_8895_().m_164861_(HouseSavedData::new, HouseSavedData::new, "house_data");
            HouseSavedData.instance.serverLevelInstance = serverLevel;
        }
    }

    public static void resetInstance() {
        instance = null;
    }

    public static HouseSavedData getInstance() {
        if (instance == null) {
            throw new IllegalStateException("HouseSavedData has not been initialized. Call initialize(ServerLevel) first.");
        }
        return instance;
    }

    public static ServerLevel getServerInstance() {
        return HouseSavedData.getInstance().getServerLevelInstance();
    }

    @Override
    protected String getDataKey() {
        return "house_data";
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag housesListTag = new ListTag();
        this.houseData.getHouses().forEach((lordUUID, house) -> housesListTag.add((Object)house.serializeNBT()));
        compoundTag.m_128365_("houses", (Tag)housesListTag);
        ListTag playersListTag = new ListTag();
        ListTag playersCodesListTag = new ListTag();
        this.houseData.getPlayerCodes().forEach((playerUUID, playerCode) -> {
            playersListTag.add((Object)StringTag.m_129297_((String)playerUUID));
            playersCodesListTag.add((Object)StringTag.m_129297_((String)playerCode));
        });
        compoundTag.m_128365_("players", (Tag)playersListTag);
        compoundTag.m_128365_("player_codes", (Tag)playersCodesListTag);
        return compoundTag;
    }

    public HouseData getHouseData() {
        return this.houseData;
    }

    public House getPlayerHouse(String suzerainUUID) {
        return this.houseData.findHouseByPlayerSuzerain(suzerainUUID);
    }

    public Domain getPlayerDomain(String playerUUID, String suzerainUUID) {
        if (!this.houseData.findDomainByKnight(playerUUID).isNull()) {
            return this.houseData.findDomainByKnight(playerUUID);
        }
        return this.houseData.findDomainByKnight(suzerainUUID);
    }

    public Boolean isColorAvailable(String color) {
        return this.houseData.getHouseAvailableColors().get(color);
    }

    public Boolean addHouse(String lordUUID, String houseTitle, String houseColor) {
        if (this.houseData.getHouses().containsKey(lordUUID) || !this.houseData.getHouseAvailableColors().get(houseColor).booleanValue()) {
            return false;
        }
        this.houseData.pushHouse(new House(lordUUID, houseTitle, houseColor));
        this.m_77762_();
        return true;
    }

    public void removeHouse(String lordUUID) {
        if (this.houseData.getHouses().containsKey(lordUUID)) {
            int[] plusCoordinates = this.houseData.removeHouse(this.houseData.findHouseByLord(lordUUID));
            ReturnPlusProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance(), plusCoordinates[0], plusCoordinates[1], plusCoordinates[2]);
            this.m_77762_();
        }
    }

    public Boolean addDomain(String lordUUID, String knightUUID, String knightDisplayName) {
        if (!this.houseData.getHouses().containsKey(lordUUID) || this.houseData.getHouses().get(lordUUID).containsDomain(knightUUID)) {
            return false;
        }
        this.houseData.pushDomain(this.houseData.findHouseByLord(lordUUID), new Domain(lordUUID, knightUUID, (Component)Component.m_237113_((String)knightDisplayName)));
        this.m_77762_();
        return true;
    }

    public void removeDomain(String lordUUID, String knightUUID) {
        if (!this.houseData.findHouseByLord(lordUUID).isNull()) {
            this.houseData.removeDomain(this.houseData.findHouseByLord(lordUUID), this.houseData.findDomainByKnight(knightUUID));
            this.m_77762_();
        }
    }

    public boolean pushPlayerToDomain(String knightUUID, String playerUUID) {
        if (this.houseData.pushPlayerToDomain(this.houseData.findHouseByKnight(knightUUID), this.houseData.findDomainByKnight(knightUUID), playerUUID)) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public void removePlayerFromDomain(String knightUUID, String playerUUID) {
        this.houseData.removePlayerFromDomain(this.houseData.findHouseByKnight(knightUUID), this.houseData.findDomainByKnight(knightUUID), playerUUID);
        this.m_77762_();
    }

    public void addWantedPlayer(String lordUUID, String playerUUID) {
        this.houseData.findHouseByLord(lordUUID).addWantedPlayer(playerUUID);
        this.m_77762_();
    }

    public void removeWantedPlayer(String lordUUID, String playerUUID) {
        this.houseData.findHouseByLord(lordUUID).removeWantedPlayer(playerUUID);
        this.m_77762_();
    }

    public int getHouseNeed(String lordUUID, HouseNeedType type) {
        House found = this.houseData.findHouseByLord(lordUUID);
        if (!found.isNull()) {
            return found.getNeed(type);
        }
        return -1;
    }

    public void setHouseNeed(String lordUUID, HouseNeedType type, int value) {
        House found = this.houseData.findHouseByLord(lordUUID);
        if (!found.isNull()) {
            found.setNeed(type, value);
            this.m_77762_();
        }
    }

    public int adjustHouseNeed(String lordUUID, HouseNeedType type, int delta) {
        House found = this.houseData.findHouseByLord(lordUUID);
        if (!found.isNull()) {
            int adjusting = found.adjustNeed(type, delta);
            this.m_77762_();
            return adjusting;
        }
        return -1;
    }
}

