/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.kingdom;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import net.mcreator.reignmod.claim.capital.CapitalClaimManager;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.house.HouseSavedData;
import net.mcreator.reignmod.procedures.CapitalServeProcedure;
import net.mcreator.reignmod.procedures.CoffersUpdateInfoProcedure;
import net.mcreator.reignmod.procedures.FundUpdateInfoProcedure;
import net.mcreator.reignmod.procedures.KingOverthrowProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class KingdomData {
    private final int[] fundCoordinates = new int[3];
    private final int[] coffersCoordinates = new int[3];
    private final int[] prisonCoordinates = new int[3];
    private int capitalEra = 0;
    private int capitalDiscontent = 0;
    private int sourceDisturbance = 0;
    private static final EnumMap<CourtPosition, String> courtiers = new EnumMap(CourtPosition.class);
    private static final HashSet<String> builders;

    public int getCapitalEra() {
        return this.capitalEra;
    }

    public void setCapitalEra(int value) {
        this.capitalEra = value;
    }

    public int getCapitalDiscontent() {
        return this.capitalDiscontent;
    }

    public void setCapitalDiscontent(int value) {
        this.capitalDiscontent = Math.max(0, Math.min(100, value));
    }

    public int getSourceDisturbance() {
        return this.sourceDisturbance;
    }

    public void setSourceDisturbance(int value) {
        this.sourceDisturbance = Math.max(0, Math.min(200, value));
    }

    public int[] getFundCoordinates() {
        return this.fundCoordinates;
    }

    public void setFundCoordinates(int x, int y, int z) {
        this.fundCoordinates[0] = x;
        this.fundCoordinates[1] = y;
        this.fundCoordinates[2] = z;
    }

    public int[] getCoffersCoordinates() {
        return this.coffersCoordinates;
    }

    public void setCoffersCoordinates(int x, int y, int z) {
        this.coffersCoordinates[0] = x;
        this.coffersCoordinates[1] = y;
        this.coffersCoordinates[2] = z;
    }

    public int[] getPrisonCoordinates() {
        return this.prisonCoordinates;
    }

    public void setPrisonCoordinates(int x, int y, int z) {
        this.prisonCoordinates[0] = x;
        this.prisonCoordinates[1] = y;
        this.prisonCoordinates[2] = z;
    }

    public String getCourtier(CourtPosition pos) {
        return courtiers.get((Object)pos);
    }

    public void assignCourtier(CourtPosition pos, String playerId) {
        courtiers.put(pos, playerId);
    }

    public void dismissCourtier(CourtPosition pos) {
        courtiers.put(pos, null);
    }

    public EnumMap<CourtPosition, String> getAllCourtiers() {
        return new EnumMap<CourtPosition, String>(courtiers);
    }

    public CourtPosition getPlayerPosition(String playerId) {
        for (Map.Entry<CourtPosition, String> entry : courtiers.entrySet()) {
            if (!playerId.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isPlayerInCourt(String playerId) {
        return courtiers.containsValue(playerId);
    }

    public HashSet<String> getBuilders() {
        return builders;
    }

    public void assignBuilder(String playerId) {
        builders.add(playerId);
    }

    public void dismissBuilder(String playerId) {
        builders.remove(playerId);
    }

    public void dismissAllBuilders() {
        builders.clear();
    }

    public boolean isPlayerBuilder(String playerId) {
        return builders.contains(playerId);
    }

    public void upgradeCapitalEra() {
        ++this.capitalEra;
        this.updateFundInfo();
    }

    public int getCapitalMaintenance() {
        int multiplier = this.capitalEra < 3 ? 1 : (this.capitalEra > 7 ? 3 : 2);
        return HouseManager.getDomainCount() * multiplier;
    }

    public void increaseCoffersAmount(int amount) {
        ServerLevel level = HouseSavedData.getServerInstance();
        if (level == null) {
            return;
        }
        BlockEntity be = this.getCoffersEntity(level);
        if (be == null) {
            return;
        }
        int current = be.getPersistentData().m_128451_("amount");
        be.getPersistentData().m_128405_("amount", current + amount);
        be.m_6596_();
    }

    public boolean decreaseCoffersAmount(int amount) {
        ServerLevel level = HouseSavedData.getServerInstance();
        if (level == null) {
            return false;
        }
        BlockEntity blockEntity = this.getCoffersEntity(level);
        if (blockEntity == null) {
            return false;
        }
        CompoundTag tag = blockEntity.m_187480_();
        int current = tag.m_128451_("amount");
        if (current < amount) {
            return false;
        }
        tag.m_128405_("amount", current - amount);
        blockEntity.m_142466_(tag);
        blockEntity.m_6596_();
        return true;
    }

    public void feedCapital() {
        boolean have = CapitalServeProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance());
        if (have) {
            this.setSourceDisturbance(this.getSourceDisturbance() - 1);
            CapitalClaimManager.enable();
        } else {
            if (this.getSourceDisturbance() < 90) {
                this.setSourceDisturbance(this.getSourceDisturbance() + 5);
            }
            CapitalClaimManager.disable();
        }
        this.waveDiscontent();
        this.updateCoffersInfo();
    }

    private void waveDiscontent() {
        if (this.getSourceDisturbance() >= 100) {
            this.setCapitalDiscontent(this.getCapitalDiscontent() + 1);
        }
        if (this.getSourceDisturbance() >= 150) {
            this.setCapitalDiscontent(this.getCapitalDiscontent() + 1);
        }
        if (this.getSourceDisturbance() == 200) {
            this.setCapitalDiscontent(this.getCapitalDiscontent() + 1);
        }
        if (this.getCapitalDiscontent() >= 100) {
            KingOverthrowProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance());
            this.setCapitalDiscontent(0);
            this.setSourceDisturbance(50);
        }
        this.updateFundInfo();
    }

    private void updateFundInfo() {
        FundUpdateInfoProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance(), this.fundCoordinates[0], this.fundCoordinates[1], this.fundCoordinates[2]);
    }

    private void updateCoffersInfo() {
        CoffersUpdateInfoProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance(), this.coffersCoordinates[0], this.coffersCoordinates[1], this.coffersCoordinates[2]);
    }

    public BlockState getFundBlockState() {
        return this.getBlockStateFromCoordinates(this.fundCoordinates);
    }

    public BlockState getCoffersBlockState() {
        return this.getBlockStateFromCoordinates(this.coffersCoordinates);
    }

    private BlockEntity getCoffersEntity(ServerLevel level) {
        return level.m_7702_(new BlockPos(this.coffersCoordinates[0], this.coffersCoordinates[1], this.coffersCoordinates[2]));
    }

    private BlockState getBlockStateFromCoordinates(int[] coordinates) {
        if (coordinates == null || coordinates.length != 3) {
            return null;
        }
        ServerLevel level = HouseSavedData.getServerInstance();
        return level == null ? null : level.m_8055_(new BlockPos(coordinates[0], coordinates[1], coordinates[2]));
    }

    static {
        for (CourtPosition pos : CourtPosition.values()) {
            courtiers.put(pos, null);
        }
        builders = new HashSet(20);
    }

    public static enum CourtPosition {
        HAND_OF_THE_KING,
        TREASURER,
        ARCHITECT,
        MARSHAL;

    }
}

