/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.market;

public class MarketItem {
    public static double MAX_AMOUNT = 6400.0;
    public static double TOOLS_MAX_AMOUNT = 64.0;
    private MarketItemType itemType;
    private double baseAmount;
    private double inPack;
    private double price;
    private double currentAmount;

    public MarketItem(double price, double baseAmount, double inPack, MarketItemType itemType) {
        this.itemType = itemType;
        this.price = price;
        this.baseAmount = baseAmount;
        this.inPack = inPack;
        this.currentAmount = 0.0;
    }

    public MarketItemType getItemType() {
        return this.itemType;
    }

    public void setItemType(MarketItemType itemType) {
        this.itemType = itemType;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getBaseAmount() {
        return this.baseAmount;
    }

    public void setBaseAmount(double baseAmount) {
        this.baseAmount = baseAmount;
    }

    public double getInPack() {
        return this.inPack;
    }

    public void setInPack(double inPack) {
        this.inPack = inPack;
    }

    public double getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(double currentAmount) {
        this.currentAmount = currentAmount;
    }

    public void adjustCurrentAmount(double delta) {
        this.currentAmount = Math.max(0.0, Math.min(MAX_AMOUNT, this.currentAmount + delta));
    }

    public static enum MarketItemType {
        LOGS,
        FUEL,
        FOOD,
        ARMOR,
        TOOLS,
        ORES,
        BLOCKS,
        OTHER,
        EXPERIENCE;

    }
}

