/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.market;

import java.util.Collection;
import java.util.HashMap;
import net.mcreator.reignmod.market.MarketItem;
import net.mcreator.reignmod.market.MarketSavedData;

public class MarketManager {
    public static Double getPrice(String itemName) {
        MarketSavedData data = MarketSavedData.getInstance();
        MarketItem item = data.getMarketItems().get(itemName);
        return item != null ? Double.valueOf(item.getPrice()) : null;
    }

    public static Double getMaxAmount(String itemName) {
        MarketSavedData data = MarketSavedData.getInstance();
        MarketItem item = data.getMarketItems().get(itemName);
        if (item == null) {
            return -1.0;
        }
        double currentCapacity = item.getBaseAmount() + data.getStorageBarrels().get((Object)item.getItemType());
        double maxCapacity = item.getItemType().equals((Object)MarketItem.MarketItemType.ARMOR) | item.getItemType().equals((Object)MarketItem.MarketItemType.TOOLS) ? MarketItem.TOOLS_MAX_AMOUNT : MarketItem.MAX_AMOUNT;
        return Math.min(currentCapacity, maxCapacity);
    }

    public static Double getInPack(String itemName) {
        MarketSavedData data = MarketSavedData.getInstance();
        MarketItem item = data.getMarketItems().get(itemName);
        return item != null ? Double.valueOf(item.getInPack()) : null;
    }

    public static Double getItemCount(String itemName) {
        MarketSavedData data = MarketSavedData.getInstance();
        MarketItem item = data.getMarketItems().get(itemName);
        return item != null ? Double.valueOf(item.getCurrentAmount()) : null;
    }

    public static boolean itemInMarket(String itemName) {
        MarketSavedData data = MarketSavedData.getInstance();
        return data.getMarketItems().containsKey(itemName);
    }

    public static HashMap<String, MarketItem> getMarketItems() {
        return MarketSavedData.getInstance().getMarketItems();
    }

    public static Collection<MarketItem> getMarketItemsCollection() {
        return MarketSavedData.getInstance().getMarketItems().values();
    }

    public static void increaseItemAmount(String itemName, double amountToIncrease) {
        MarketSavedData data = MarketSavedData.getInstance();
        MarketItem item = data.getMarketItems().get(itemName);
        if (item != null) {
            item.adjustCurrentAmount(amountToIncrease);
            data.markRefreshNeeded();
            data.m_77762_();
        }
    }

    public static void decreaseItemAmount(String itemName, double amountToDecrease) {
        MarketSavedData data = MarketSavedData.getInstance();
        MarketItem item = data.getMarketItems().get(itemName);
        if (item != null) {
            item.adjustCurrentAmount(-amountToDecrease);
            data.markRefreshNeeded();
            data.m_77762_();
        }
    }

    public static void adjustBarrelCapacity(MarketItem.MarketItemType itemType, double delta) {
        MarketSavedData data = MarketSavedData.getInstance();
        Double capacity = data.getStorageBarrels().get((Object)itemType);
        if (capacity != null) {
            data.getStorageBarrels().put(itemType, capacity + delta);
            data.markRefreshNeeded();
            data.m_77762_();
        }
    }

    public static void markRefresh() {
        MarketSavedData.getInstance().markRefreshNeeded();
    }

    public static void clearRefresh() {
        MarketSavedData.getInstance().clearRefreshFlag();
    }

    public static boolean isRefreshNeeded() {
        return MarketSavedData.getInstance().isRefreshRequired();
    }
}

