/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.market;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.mcreator.reignmod.basics.ConfigLoader;
import net.mcreator.reignmod.basics.ReignSavedData;
import net.mcreator.reignmod.market.MarketItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;

public class MarketSavedData
extends ReignSavedData {
    private HashMap<String, MarketItem> marketItems;
    private EnumMap<MarketItem.MarketItemType, Double> storageBarrels;
    private static MarketSavedData instance;
    private boolean requireRefresh = true;

    public MarketSavedData() {
        this.loadDefaults();
    }

    public MarketSavedData(CompoundTag compoundTag) {
        CompoundTag dataTag;
        this.loadDefaults();
        if (compoundTag.m_128441_("marketData")) {
            dataTag = compoundTag.m_128469_("marketData");
            for (String key : dataTag.m_128431_()) {
                double currentAmount = dataTag.m_128459_(key);
                if (!this.marketItems.containsKey(key)) continue;
                this.marketItems.get(key).setCurrentAmount(currentAmount);
            }
        }
        if (compoundTag.m_128441_("barrelsData")) {
            dataTag = compoundTag.m_128469_("barrelsData");
            for (String key : dataTag.m_128431_()) {
                this.storageBarrels.put(MarketItem.MarketItemType.valueOf(key), dataTag.m_128459_(key));
            }
        }
    }

    private void loadDefaults() {
        this.marketItems = new HashMap();
        for (Map.Entry<String, MarketItem> entry : ConfigLoader.getMarketItems().entrySet()) {
            MarketItem defaultItem = entry.getValue();
            this.marketItems.put(entry.getKey(), new MarketItem(defaultItem.getPrice(), defaultItem.getBaseAmount(), defaultItem.getInPack(), defaultItem.getItemType()));
        }
        this.storageBarrels = new EnumMap(MarketItem.MarketItemType.class);
        for (MarketItem.MarketItemType itemType : MarketItem.MarketItemType.values()) {
            this.storageBarrels.put(itemType, 0.0);
        }
    }

    @Override
    protected String getDataKey() {
        return "market_data";
    }

    public static void initialize(ServerLevel serverLevel) {
        if (instance == null) {
            instance = (MarketSavedData)serverLevel.m_8895_().m_164861_(MarketSavedData::new, MarketSavedData::new, "market_data");
            MarketSavedData.instance.serverLevelInstance = serverLevel;
        }
    }

    public static MarketSavedData getInstance() {
        if (instance == null) {
            throw new IllegalStateException("MarketSavedData has not been initialized. Call initialize(ServerLevel) first.");
        }
        return instance;
    }

    public static void resetInstance() {
        instance = null;
    }

    public static ServerLevel getServerInstance() {
        return MarketSavedData.getInstance().getServerLevelInstance();
    }

    public void markRefreshNeeded() {
        this.requireRefresh = true;
    }

    public void clearRefreshFlag() {
        this.requireRefresh = false;
    }

    public boolean isRefreshRequired() {
        return this.requireRefresh;
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        CompoundTag dataTag = new CompoundTag();
        for (Map.Entry<String, MarketItem> entry : this.marketItems.entrySet()) {
            dataTag.m_128347_(entry.getKey(), entry.getValue().getCurrentAmount());
        }
        compoundTag.m_128365_("marketData", (Tag)dataTag);
        CompoundTag barrelsTag = new CompoundTag();
        for (Map.Entry<MarketItem.MarketItemType, Double> entry : this.storageBarrels.entrySet()) {
            if (entry.getValue() == null) continue;
            barrelsTag.m_128347_(entry.getKey().name(), entry.getValue().doubleValue());
        }
        compoundTag.m_128365_("barrelsData", (Tag)barrelsTag);
        return compoundTag;
    }

    public HashMap<String, MarketItem> getMarketItems() {
        return this.marketItems;
    }

    public EnumMap<MarketItem.MarketItemType, Double> getStorageBarrels() {
        return this.storageBarrels;
    }
}

