/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.mines;

import net.mcreator.reignmod.mines.MineConstants;
import net.mcreator.reignmod.mines.MineRichness;
import net.mcreator.reignmod.mines.MineSavedData;
import net.mcreator.reignmod.mines.MineType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;

public class MineData {
    private final ChunkPos chunkPos;
    private final MineType type;
    private final MineRichness richness;
    private double capacity;
    private BlockPos mineBlockPos;

    public MineData(ChunkPos chunkPos, MineType type, MineRichness richness) {
        this.chunkPos = chunkPos;
        this.type = type;
        this.richness = richness;
        double baseCap = MineConstants.MAX_CAPACITY.getOrDefault((Object)type, 0.0);
        double value = 0.7 + MineSavedData.getRandom().m_188500_() * 0.6000000000000001;
        this.capacity = baseCap * (richness == MineRichness.RICH ? 3.0 : 1.0) * value;
        this.mineBlockPos = null;
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public MineType getType() {
        return this.type;
    }

    public MineRichness getRichness() {
        return this.richness;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void reduceCapacity(double amount) {
        this.capacity = Math.max(0.0, this.capacity - amount);
    }

    public BlockPos getMineBlockPos() {
        return this.mineBlockPos;
    }

    public void setMineBlockPos(BlockPos pos) {
        this.mineBlockPos = pos;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("chunkX", this.chunkPos.f_45578_);
        tag.m_128405_("chunkZ", this.chunkPos.f_45579_);
        tag.m_128359_("type", this.type.name());
        tag.m_128359_("richness", this.richness.name());
        tag.m_128347_("capacity", this.capacity);
        if (this.mineBlockPos != null) {
            tag.m_128356_("minePos", this.mineBlockPos.m_121878_());
        }
        return tag;
    }

    public static MineData load(CompoundTag tag) {
        int chunkX = tag.m_128451_("chunkX");
        int chunkZ = tag.m_128451_("chunkZ");
        ChunkPos chunk = new ChunkPos(chunkX, chunkZ);
        MineType type = MineType.valueOf(tag.m_128461_("type"));
        MineRichness richness = MineRichness.valueOf(tag.m_128461_("richness"));
        MineData data = new MineData(chunk, type, richness);
        data.capacity = tag.m_128459_("capacity");
        if (tag.m_128441_("minePos")) {
            data.setMineBlockPos(BlockPos.m_122022_((long)tag.m_128454_("minePos")));
        }
        return data;
    }
}

