/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.network;

import java.util.function.Supplier;
import net.mcreator.reignmod.ReignModMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ReignModModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ReignModMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ReignModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.license_woodcuter = message.data.license_woodcuter;
                    variables.license_smith = message.data.license_smith;
                    variables.license_fisher = message.data.license_fisher;
                    variables.license_miner = message.data.license_miner;
                    variables.license_farmer = message.data.license_farmer;
                    variables.license_soldier = message.data.license_soldier;
                    variables.license_alchemist = message.data.license_alchemist;
                    variables.license_librarian = message.data.license_librarian;
                    variables.taxInTransaction = message.data.taxInTransaction;
                    variables.MAIN_LVL = message.data.MAIN_LVL;
                    variables.ADD_LVL = message.data.ADD_LVL;
                    variables.last_refuse_day = message.data.last_refuse_day;
                    variables.isCriminal = message.data.isCriminal;
                    variables.FirstEnter = message.data.FirstEnter;
                    variables.LastEnter_Day = message.data.LastEnter_Day;
                    variables.DaysOnline = message.data.DaysOnline;
                    variables.license_cowboy = message.data.license_cowboy;
                    variables.license_hunter = message.data.license_hunter;
                    variables.house = message.data.house;
                    variables.player_prefix = message.data.player_prefix;
                    variables.R_LVL = message.data.R_LVL;
                    variables.LastEnter_Week = message.data.LastEnter_Week;
                    variables.efficiency = message.data.efficiency;
                    variables.last_refuse_week = message.data.last_refuse_week;
                    variables.prison_house = message.data.prison_house;
                    variables.market_goods_count = message.data.market_goods_count;
                    variables.vip = message.data.vip;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean license_woodcuter = false;
        public boolean license_smith = false;
        public boolean license_fisher = false;
        public boolean license_miner = false;
        public boolean license_farmer = false;
        public boolean license_soldier = false;
        public boolean license_alchemist = false;
        public boolean license_librarian = false;
        public double taxInTransaction = 0.0;
        public double MAIN_LVL = 0.0;
        public double ADD_LVL = 0.0;
        public double last_refuse_day = 0.0;
        public boolean isCriminal = false;
        public boolean FirstEnter = false;
        public double LastEnter_Day = 0.0;
        public double DaysOnline = 0.0;
        public boolean license_cowboy = false;
        public boolean license_hunter = false;
        public String house = "";
        public String player_prefix = "";
        public boolean R_LVL = false;
        public double LastEnter_Week = 0.0;
        public double efficiency = 0.0;
        public double last_refuse_week = 0.0;
        public String prison_house = "";
        public String market_goods_count = "\"\"";
        public double vip = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ReignModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("license_woodcuter", this.license_woodcuter);
            nbt.m_128379_("license_smith", this.license_smith);
            nbt.m_128379_("license_fisher", this.license_fisher);
            nbt.m_128379_("license_miner", this.license_miner);
            nbt.m_128379_("license_farmer", this.license_farmer);
            nbt.m_128379_("license_soldier", this.license_soldier);
            nbt.m_128379_("license_alchemist", this.license_alchemist);
            nbt.m_128379_("license_librarian", this.license_librarian);
            nbt.m_128347_("taxInTransaction", this.taxInTransaction);
            nbt.m_128347_("MAIN_LVL", this.MAIN_LVL);
            nbt.m_128347_("ADD_LVL", this.ADD_LVL);
            nbt.m_128347_("last_refuse_day", this.last_refuse_day);
            nbt.m_128379_("isCriminal", this.isCriminal);
            nbt.m_128379_("FirstEnter", this.FirstEnter);
            nbt.m_128347_("LastEnter_Day", this.LastEnter_Day);
            nbt.m_128347_("DaysOnline", this.DaysOnline);
            nbt.m_128379_("license_cowboy", this.license_cowboy);
            nbt.m_128379_("license_hunter", this.license_hunter);
            nbt.m_128359_("house", this.house);
            nbt.m_128359_("player_prefix", this.player_prefix);
            nbt.m_128379_("R_LVL", this.R_LVL);
            nbt.m_128347_("LastEnter_Week", this.LastEnter_Week);
            nbt.m_128347_("efficiency", this.efficiency);
            nbt.m_128347_("last_refuse_week", this.last_refuse_week);
            nbt.m_128359_("prison_house", this.prison_house);
            nbt.m_128359_("market_goods_count", this.market_goods_count);
            nbt.m_128347_("vip", this.vip);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.license_woodcuter = nbt.m_128471_("license_woodcuter");
            this.license_smith = nbt.m_128471_("license_smith");
            this.license_fisher = nbt.m_128471_("license_fisher");
            this.license_miner = nbt.m_128471_("license_miner");
            this.license_farmer = nbt.m_128471_("license_farmer");
            this.license_soldier = nbt.m_128471_("license_soldier");
            this.license_alchemist = nbt.m_128471_("license_alchemist");
            this.license_librarian = nbt.m_128471_("license_librarian");
            this.taxInTransaction = nbt.m_128459_("taxInTransaction");
            this.MAIN_LVL = nbt.m_128459_("MAIN_LVL");
            this.ADD_LVL = nbt.m_128459_("ADD_LVL");
            this.last_refuse_day = nbt.m_128459_("last_refuse_day");
            this.isCriminal = nbt.m_128471_("isCriminal");
            this.FirstEnter = nbt.m_128471_("FirstEnter");
            this.LastEnter_Day = nbt.m_128459_("LastEnter_Day");
            this.DaysOnline = nbt.m_128459_("DaysOnline");
            this.license_cowboy = nbt.m_128471_("license_cowboy");
            this.license_hunter = nbt.m_128471_("license_hunter");
            this.house = nbt.m_128461_("house");
            this.player_prefix = nbt.m_128461_("player_prefix");
            this.R_LVL = nbt.m_128471_("R_LVL");
            this.LastEnter_Week = nbt.m_128459_("LastEnter_Week");
            this.efficiency = nbt.m_128459_("efficiency");
            this.last_refuse_week = nbt.m_128459_("last_refuse_week");
            this.prison_house = nbt.m_128461_("prison_house");
            this.market_goods_count = nbt.m_128461_("market_goods_count");
            this.vip = nbt.m_128459_("vip");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("reign_mod", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "reign_mod_mapvars";
        public double logs_price = 0.0;
        public double coal_price = 0.0;
        public double food_price = 0.0;
        public double armor_price = 0.0;
        public double tools_price = 0.0;
        public double other_price = 0.0;
        public double ores_price = 0.0;
        public double ERA = 0.0;
        public boolean CapitalHave = false;
        public double CAPITAL_X = 0.0;
        public double CAPITAL_Y = 0.0;
        public double CAPITAL_Z = 0.0;
        public double crown_id = 0.0;
        public boolean EVENT_PLAGUE = false;
        public boolean EVENT_STARVATION = false;
        public double Tutorial_pass = 0.0;
        public double MAX_AMOUNT_VALUE = 279616.0;
        public double FEED_K = 1.0;
        public double market_copper = 0.0;
        public double market_copper_all = 0.0;
        public double SurgingSource = 0.0;
        public double exp_price = 0.0;
        public double private_price = 0.0;
        public boolean coinage_block = false;
        public boolean needRefresh = false;
        public double dpk = 0.0;
        public double last_grace_week = 0.0;
        public double last_grace_day = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.logs_price = nbt.m_128459_("logs_price");
            this.coal_price = nbt.m_128459_("coal_price");
            this.food_price = nbt.m_128459_("food_price");
            this.armor_price = nbt.m_128459_("armor_price");
            this.tools_price = nbt.m_128459_("tools_price");
            this.other_price = nbt.m_128459_("other_price");
            this.ores_price = nbt.m_128459_("ores_price");
            this.ERA = nbt.m_128459_("ERA");
            this.CapitalHave = nbt.m_128471_("CapitalHave");
            this.CAPITAL_X = nbt.m_128459_("CAPITAL_X");
            this.CAPITAL_Y = nbt.m_128459_("CAPITAL_Y");
            this.CAPITAL_Z = nbt.m_128459_("CAPITAL_Z");
            this.crown_id = nbt.m_128459_("crown_id");
            this.EVENT_PLAGUE = nbt.m_128471_("EVENT_PLAGUE");
            this.EVENT_STARVATION = nbt.m_128471_("EVENT_STARVATION");
            this.Tutorial_pass = nbt.m_128459_("Tutorial_pass");
            this.MAX_AMOUNT_VALUE = nbt.m_128459_("MAX_AMOUNT_VALUE");
            this.FEED_K = nbt.m_128459_("FEED_K");
            this.market_copper = nbt.m_128459_("market_copper");
            this.market_copper_all = nbt.m_128459_("market_copper_all");
            this.SurgingSource = nbt.m_128459_("SurgingSource");
            this.exp_price = nbt.m_128459_("exp_price");
            this.private_price = nbt.m_128459_("private_price");
            this.coinage_block = nbt.m_128471_("coinage_block");
            this.needRefresh = nbt.m_128471_("needRefresh");
            this.dpk = nbt.m_128459_("dpk");
            this.last_grace_week = nbt.m_128459_("last_grace_week");
            this.last_grace_day = nbt.m_128459_("last_grace_day");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("logs_price", this.logs_price);
            nbt.m_128347_("coal_price", this.coal_price);
            nbt.m_128347_("food_price", this.food_price);
            nbt.m_128347_("armor_price", this.armor_price);
            nbt.m_128347_("tools_price", this.tools_price);
            nbt.m_128347_("other_price", this.other_price);
            nbt.m_128347_("ores_price", this.ores_price);
            nbt.m_128347_("ERA", this.ERA);
            nbt.m_128379_("CapitalHave", this.CapitalHave);
            nbt.m_128347_("CAPITAL_X", this.CAPITAL_X);
            nbt.m_128347_("CAPITAL_Y", this.CAPITAL_Y);
            nbt.m_128347_("CAPITAL_Z", this.CAPITAL_Z);
            nbt.m_128347_("crown_id", this.crown_id);
            nbt.m_128379_("EVENT_PLAGUE", this.EVENT_PLAGUE);
            nbt.m_128379_("EVENT_STARVATION", this.EVENT_STARVATION);
            nbt.m_128347_("Tutorial_pass", this.Tutorial_pass);
            nbt.m_128347_("MAX_AMOUNT_VALUE", this.MAX_AMOUNT_VALUE);
            nbt.m_128347_("FEED_K", this.FEED_K);
            nbt.m_128347_("market_copper", this.market_copper);
            nbt.m_128347_("market_copper_all", this.market_copper_all);
            nbt.m_128347_("SurgingSource", this.SurgingSource);
            nbt.m_128347_("exp_price", this.exp_price);
            nbt.m_128347_("private_price", this.private_price);
            nbt.m_128379_("coinage_block", this.coinage_block);
            nbt.m_128379_("needRefresh", this.needRefresh);
            nbt.m_128347_("dpk", this.dpk);
            nbt.m_128347_("last_grace_week", this.last_grace_week);
            nbt.m_128347_("last_grace_day", this.last_grace_day);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ReignModMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "reign_mod_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ReignModMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.license_woodcuter = original.license_woodcuter;
            clone.license_smith = original.license_smith;
            clone.license_fisher = original.license_fisher;
            clone.license_miner = original.license_miner;
            clone.license_farmer = original.license_farmer;
            clone.license_soldier = original.license_soldier;
            clone.license_alchemist = original.license_alchemist;
            clone.license_librarian = original.license_librarian;
            clone.taxInTransaction = original.taxInTransaction;
            clone.MAIN_LVL = original.MAIN_LVL;
            clone.ADD_LVL = original.ADD_LVL;
            clone.last_refuse_day = original.last_refuse_day;
            clone.isCriminal = original.isCriminal;
            clone.FirstEnter = original.FirstEnter;
            clone.LastEnter_Day = original.LastEnter_Day;
            clone.DaysOnline = original.DaysOnline;
            clone.license_cowboy = original.license_cowboy;
            clone.license_hunter = original.license_hunter;
            clone.house = original.house;
            clone.player_prefix = original.player_prefix;
            clone.R_LVL = original.R_LVL;
            clone.LastEnter_Week = original.LastEnter_Week;
            clone.efficiency = original.efficiency;
            clone.last_refuse_week = original.last_refuse_week;
            clone.prison_house = original.prison_house;
            clone.market_goods_count = original.market_goods_count;
            clone.vip = original.vip;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ReignModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ReignModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ReignModMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

