/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.basics;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.mcreator.reignmod.basics.LastKnownLocation;
import net.mcreator.reignmod.house.HouseSavedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;

public final class PlayerLocationUtil {
    public static void applyLocationOnCompass(ItemStack compass, String uuid, Entity hunter) {
        if (hunter instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)hunter;
            Optional<LastKnownLocation> location = PlayerLocationUtil.getLastKnownLocation(HouseSavedData.getServerInstance().m_7654_(), UUID.fromString(uuid), sp);
            location.ifPresent(lastKnownLocation -> PlayerLocationUtil.applyLodestoneTarget(compass, lastKnownLocation));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<LastKnownLocation> getLastKnownLocation(MinecraftServer server, UUID targetUUID, ServerPlayer hunter) {
        ServerPlayer online = server.m_6846_().m_11259_(targetUUID);
        if (online != null) {
            Vec3 pos = online.m_20182_();
            double distance = PlayerLocationUtil.distanceXZ(hunter.m_20185_(), hunter.m_20189_(), pos.f_82479_, pos.f_82481_);
            double threshold = Math.max(16.0, 0.25 * distance);
            Vec3 randPos = new Vec3((double)PlayerLocationUtil.randIntInclusive((int)(pos.f_82479_ - threshold), (int)(pos.f_82479_ + threshold)), pos.f_82480_, (double)PlayerLocationUtil.randIntInclusive((int)(pos.f_82481_ - threshold), (int)(pos.f_82481_ + threshold)));
            return Optional.of(new LastKnownLocation((ResourceKey<Level>)online.m_9236_().m_46472_(), randPos));
        }
        Path playerDat = server.m_129843_(LevelResource.f_78176_).resolve(String.valueOf(targetUUID) + ".dat");
        if (!Files.exists(playerDat, new LinkOption[0])) {
            Path old = server.m_129843_(LevelResource.f_78176_).resolve(String.valueOf(targetUUID) + ".dat_old");
            if (!Files.exists(old, new LinkOption[0])) return Optional.empty();
            playerDat = old;
        }
        try (InputStream is = Files.newInputStream(playerDat, new OpenOption[0]);){
            String dimId;
            CompoundTag nbt = NbtIo.m_128939_((InputStream)is);
            if (!nbt.m_128425_("Pos", 9)) {
                Optional<LastKnownLocation> threshold = Optional.empty();
                return threshold;
            }
            ListTag posList = nbt.m_128437_("Pos", 6);
            if (posList.size() < 3) {
                Optional<LastKnownLocation> optional = Optional.empty();
                return optional;
            }
            double x = posList.m_128772_(0);
            double y = posList.m_128772_(1);
            double z = posList.m_128772_(2);
            double distance = PlayerLocationUtil.distanceXZ(hunter.m_20185_(), hunter.m_20189_(), x, z);
            double threshold = Math.max(32.0, 0.25 * distance);
            Vec3 pos = new Vec3((double)PlayerLocationUtil.randIntInclusive((int)(x - threshold), (int)(x + threshold)), y, (double)PlayerLocationUtil.randIntInclusive((int)(z - threshold), (int)(z + threshold)));
            ResourceKey dimKey = Level.f_46428_;
            if (nbt.m_128425_("Dimension", 8) && !(dimId = nbt.m_128461_("Dimension")).isEmpty()) {
                dimKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimId));
            }
            Optional<LastKnownLocation> optional = Optional.of(new LastKnownLocation((ResourceKey<Level>)dimKey, pos));
            return optional;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static void applyLodestoneTarget(ItemStack compass, LastKnownLocation loc) {
        if (!compass.m_150930_(Items.f_42522_)) {
            return;
        }
        BlockPos bp = loc.blockPos();
        CompoundTag tag = compass.m_41784_();
        tag.m_128365_("LodestonePos", (Tag)NbtUtils.m_129224_((BlockPos)bp));
        tag.m_128359_("LodestoneDimension", loc.dimension().m_135782_().toString());
        tag.m_128379_("LodestoneTracked", false);
    }

    public static double distanceXZ(double x1, double z1, double x2, double z2) {
        return Math.hypot(x2 - x1, z2 - z1);
    }

    public static int randIntInclusive(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("min > max");
        }
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }
}

