/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.basics;

import com.mojang.authlib.GameProfile;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import net.mcreator.reignmod.basics.ReignChatEventUtil;
import net.mcreator.reignmod.networking.ClientPlayerData;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ReignChatEvent {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Optional<String> findDisplayNameByNameTab(String name) {
        Minecraft mc = Minecraft.m_91087_();
        ClientPacketListener conn = mc.m_91403_();
        if (conn == null || name == null) {
            return Optional.empty();
        }
        for (PlayerInfo info : conn.m_105142_()) {
            GameProfile profile = info.m_105312_();
            if (profile.getName() == null || !profile.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(ClientPlayerData.getPlayersPrefixes().getOrDefault(profile.getId().toString(), "") + name);
        }
        return Optional.empty();
    }

    public static Component onClientChat(ChatType type, Component message, UUID senderUUID) {
        Optional<String> displayNameOpt;
        String chatInRaw = message.getString();
        if (!chatInRaw.startsWith("<") || !chatInRaw.contains("> ")) {
            return message;
        }
        String[] cirspl = chatInRaw.split("> ");
        if (cirspl.length < 2) {
            return message;
        }
        String timestamp = new SimpleDateFormat("HH:mm").format(new Date());
        String user = cirspl[0].substring(1);
        String messageString = chatInRaw.replace(cirspl[0] + "> ", "");
        if (!user.contains("[") && (displayNameOpt = ReignChatEvent.findDisplayNameByNameTab(user)).isPresent()) {
            user = displayNameOpt.get();
        }
        return ReignChatEvent.getMutableComponent(timestamp, user, messageString);
    }

    @NotNull
    private static MutableComponent getMutableComponent(String timestamp, String user, String messageString) {
        MutableComponent output = Component.m_237113_((String)"");
        String raw_outputstring = "%timestamp% | %username%: %chatmessage%";
        for (String word : raw_outputstring.split("%")) {
            ChatFormatting colour = ReignChatEventUtil.getColour(word);
            String toappend = word;
            if (word.equalsIgnoreCase("timestamp")) {
                toappend = timestamp;
            } else if (word.equalsIgnoreCase("username")) {
                toappend = user;
            } else if (word.equalsIgnoreCase("chatmessage")) {
                toappend = messageString;
            }
            MutableComponent wordcomponent = Component.m_237113_((String)toappend);
            wordcomponent.m_130940_(colour);
            output.m_7220_((Component)wordcomponent);
        }
        return output;
    }
}

