/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.basics;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import net.mcreator.reignmod.basics.ReignChatEvent;
import net.mcreator.reignmod.basics.ReignCommon;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.house.HouseSavedData;
import net.mcreator.reignmod.init.ReignModModItems;
import net.mcreator.reignmod.kingdom.KingdomManager;
import net.mcreator.reignmod.networking.ClientPlayerData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import virtuoel.pehkui.api.ScaleTypes;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ReignChatEventSubscriber {
    private static final Pattern COLORED_PREFIX_AT_START = Pattern.compile("^\u00a7r\\[\u00a7.{3,}?\u00a7r]\\s*");

    public static String stripColoredPrefix(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return COLORED_PREFIX_AT_START.matcher(s).replaceFirst("");
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClientChat(ClientChatReceivedEvent e) {
        Component newMessage;
        Component originalMessage = e.getMessage();
        if (originalMessage != (newMessage = ReignChatEvent.onClientChat(null, e.getMessage(), e.getSender()))) {
            e.setMessage(newMessage);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderNameTag(RenderNameTagEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        String basePrefix = ReignChatEventSubscriber.stripColoredPrefix(ClientPlayerData.getPlayersPrefixes().getOrDefault(p.m_20149_(), ""));
        e.setContent((Component)Component.m_237113_((String)(basePrefix + p.m_7755_().getString())));
        String status = ReignChatEventSubscriber.getPlayerStatus(p);
        if (!status.isEmpty()) {
            Minecraft mc = Minecraft.m_91087_();
            if (p == mc.f_91074_) {
                return;
            }
            if (p.m_21124_(MobEffects.f_19609_) != null) {
                return;
            }
            Font font = mc.f_91062_;
            PoseStack ps = e.getPoseStack();
            MultiBufferSource buf = e.getMultiBufferSource();
            int light = e.getPackedLight();
            EntityRenderDispatcher erd = mc.m_91290_();
            if (ForgeHooksClient.isNameplateInRenderDistance((Entity)p, (double)p.m_20238_(erd.f_114358_.m_90583_()))) {
                float modelScale = 1.0f;
                if (ModList.get().isLoaded("pehkui")) {
                    modelScale = ScaleTypes.MODEL_HEIGHT.getScaleData((Entity)p).getScale();
                }
                float nameY = p.m_20206_() / modelScale + 0.5f;
                ps.m_85836_();
                ps.m_252880_(0.0f, nameY, 0.0f);
                ps.m_252781_(erd.m_253208_());
                ps.m_85841_(-0.025f, -0.025f, 0.025f);
                Component vanillaName = e.getContent();
                int baseW = font.m_92852_((FormattedText)vanillaName);
                MutableComponent line = Component.m_237113_((String)status);
                int statusW = font.m_92852_((FormattedText)line);
                float x = (float)(-font.m_92852_((FormattedText)line)) / 2.0f;
                Objects.requireNonNull(font);
                float y = -(9.0f + 2.0f);
                int bg = (int)(mc.f_91066_.m_92141_(0.25f) * 255.0f) << 24;
                font.m_272077_((Component)line, x, y, -1, false, ps.m_85850_().m_252922_(), buf, Font.DisplayMode.NORMAL, bg, light);
                ps.m_85849_();
            }
        }
    }

    @NotNull
    private static String getPlayerStatus(Player p) {
        String status = "";
        if (p.m_7500_()) {
            status = ReignCommon.opPrefix.strip();
        } else {
            PlayerInfo info;
            Minecraft mc = Minecraft.m_91087_();
            ClientPacketListener conn = mc.m_91403_();
            if (conn != null && (info = conn.m_104949_(p.m_20148_())) != null && info.m_105325_() == GameType.ADVENTURE) {
                status = ReignCommon.travelerPrefix.strip();
            }
        }
        return status;
    }

    @SubscribeEvent
    public static void onGameModeChange(PlayerEvent.PlayerChangeGameModeEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            HouseManager.playerPrefixSynchronize((Player)sp, event.getNewGameMode());
            HouseManager.allPlayersPrefixPacketSend();
        }
    }

    @SubscribeEvent
    public static void onHelmetChange(LivingEquipmentChangeEvent event) {
        UUID currentKingUUID;
        UUID playerUUID;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)livingEntity;
        if (event.getSlot() != EquipmentSlot.HEAD) {
            return;
        }
        Item crownHelmet = (Item)ReignModModItems.CROWN_HELMET.get();
        boolean isOldItemCrown = event.getFrom().m_41720_().equals(crownHelmet);
        boolean isNewItemCrown = event.getTo().m_41720_().equals(crownHelmet);
        if (!isOldItemCrown && !isNewItemCrown) {
            return;
        }
        HouseManager.playerPrefixSynchronize((Player)sp);
        HouseManager.allPlayersPrefixPacketSend();
        if (isNewItemCrown && !(playerUUID = sp.m_20148_()).equals(currentKingUUID = KingdomManager.getKingUUID()) && HouseManager.isPlayerLord((Player)sp)) {
            KingdomManager.setKingUUID(playerUUID);
            HouseSavedData.getInstance().getHouseData().getHouses().values().forEach(House::disableOathToKing);
            HouseManager.getPlayerHouse((Player)sp).enableOathToKing();
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            HouseManager.playerPrefixSynchronize((Player)sp);
            HouseManager.allPlayersPrefixPacketSend();
        }
    }
}

