/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.basics.transmutation;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.mcreator.reignmod.basics.transmutation.TransmutationRecipe;
import net.mcreator.reignmod.init.ReignModModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;

public class TransmutationManager {
    private static final Map<Item, TransmutationRecipe> RECIPES = new HashMap<Item, TransmutationRecipe>();
    private static final Random RANDOM = new Random();

    private static void initializeRecipes() {
        RECIPES.put(Items.f_42436_, new TransmutationRecipe.Builder().input(Items.f_42436_).output(Items.f_42437_).addEnchantment(Enchantments.f_44965_, 5).build());
        RECIPES.put(Items.f_42398_, new TransmutationRecipe.Builder().input(Items.f_42398_).output(Items.f_42585_).addEnchantment(Enchantments.f_44966_, 10).addEnchantment(Enchantments.f_44981_, 15).addEnchantment(Enchantments.f_44990_, 30).build());
        RECIPES.put((Item)ReignModModItems.BLACKMARK.get(), new TransmutationRecipe.Builder().input((Item)ReignModModItems.BLACKMARK.get()).output((Item)ReignModModItems.ACCURSED_BLACK_MARK.get()).addEnchantment(Enchantments.f_44975_, 31).addEnchantment(Enchantments.f_44963_, 31).addEnchantment(Enchantments.f_44978_, 13).build());
    }

    public static void registerRecipe(Item inputItem, TransmutationRecipe recipe) {
        RECIPES.put(inputItem, recipe);
    }

    public static TransmutationRecipe getRecipe(Item inputItem) {
        return RECIPES.get(inputItem);
    }

    public static TransmutationResult performTransmutation(ItemStack inputItem, ItemStack enchantedBook) {
        boolean success;
        TransmutationRecipe recipe = RECIPES.get(inputItem.m_41720_());
        TransmutationResult a = new TransmutationResult(false, false, null, 0);
        if (recipe == null) {
            return new TransmutationResult(false, false, null, 0);
        }
        if (!recipe.matches(inputItem.m_41720_())) {
            return new TransmutationResult(false, false, null, 0);
        }
        if (!enchantedBook.m_150930_(Items.f_42690_)) {
            return new TransmutationResult(false, false, null, 0);
        }
        int successChance = recipe.calculateSuccessChance(enchantedBook);
        if (successChance <= 0) {
            return new TransmutationResult(false, false, null, successChance);
        }
        boolean bl = success = RANDOM.nextInt(100) < successChance;
        if (success) {
            return new TransmutationResult(true, true, recipe.outputItem(), successChance);
        }
        return new TransmutationResult(true, false, null, successChance);
    }

    static {
        TransmutationManager.initializeRecipes();
    }

    public record TransmutationResult(boolean correctRecipe, boolean success, Item resultItem, int chance) {
    }
}

