/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.basics.transmutation;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public record TransmutationRecipe(Item inputItem, Item outputItem, Map<Enchantment, Integer> supportedEnchantments) {
    public boolean matches(Item input) {
        return input.equals(this.inputItem);
    }

    public int calculateSuccessChance(ItemStack enchantedBook) {
        if (!enchantedBook.m_150930_(Items.f_42690_)) {
            return 0;
        }
        Map bookEnchantments = EnchantmentHelper.m_44831_((ItemStack)enchantedBook);
        int totalChance = 0;
        for (Map.Entry entry : bookEnchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            if (!this.supportedEnchantments.containsKey(enchantment)) continue;
            int chancePerLevel = this.supportedEnchantments.get(enchantment);
            totalChance += chancePerLevel * level;
        }
        return Math.max(0, Math.min(totalChance, 95));
    }

    public static class Builder {
        private Item inputItem;
        private Item outputItem;
        private final Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();

        public Builder input(Item item) {
            this.inputItem = item;
            return this;
        }

        public Builder output(Item item) {
            this.outputItem = item;
            return this;
        }

        public Builder addEnchantment(Enchantment enchantment, int chancePerLevel) {
            this.enchantments.put(enchantment, chancePerLevel);
            return this;
        }

        public TransmutationRecipe build() {
            return new TransmutationRecipe(this.inputItem, this.outputItem, this.enchantments);
        }
    }
}

