/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.claim.capital;

import java.util.HashSet;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class ClaimOwner {
    private final UUID mainOwner;
    private final HashSet<UUID> coOwners = new HashSet();

    public ClaimOwner(UUID mainOwner) {
        this.mainOwner = mainOwner;
    }

    public static ClaimOwner deserializeNBT(CompoundTag tag) {
        UUID main = UUID.fromString(tag.m_128461_("mainOwner"));
        ClaimOwner owner = new ClaimOwner(main);
        ListTag coOwnersList = tag.m_128437_("coOwners", 8);
        for (int i = 0; i < coOwnersList.size(); ++i) {
            owner.addCoOwner(UUID.fromString(coOwnersList.m_128778_(i)));
        }
        return owner;
    }

    public UUID getMainOwner() {
        return this.mainOwner;
    }

    public HashSet<UUID> getCoOwners() {
        return this.coOwners;
    }

    public void addCoOwner(UUID coOwner) {
        this.coOwners.add(coOwner);
    }

    public void removeCoOwner(UUID coOwner) {
        this.coOwners.remove(coOwner);
    }

    public boolean hasAccess(UUID playerUUID) {
        return this.mainOwner.equals(playerUUID) || this.coOwners.contains(playerUUID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ClaimOwner)) return false;
        ClaimOwner other = (ClaimOwner)obj;
        if (!this.mainOwner.equals(other.mainOwner)) return false;
        return true;
    }

    public int hashCode() {
        return this.mainOwner.hashCode();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("mainOwner", this.mainOwner.toString());
        ListTag coOwnersList = new ListTag();
        for (UUID uuid : this.coOwners) {
            coOwnersList.add((Object)StringTag.m_129297_((String)uuid.toString()));
        }
        tag.m_128365_("coOwners", (Tag)coOwnersList);
        return tag;
    }
}

