/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.house;

import java.util.ArrayList;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseManager;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.StringUtils;

public class HouseCommands {
    public static String getHouseWantedPlayers(ServerPlayer player) {
        ArrayList<String> wantedList = HouseManager.getHouseWantedPlayers(player);
        StringBuilder wantedListMerged = new StringBuilder(Component.m_237115_((String)"house.get_house_wanted").getString());
        if (!wantedList.isEmpty()) {
            wantedListMerged.append('\n');
        }
        for (String wanted : wantedList) {
            wantedListMerged.append("\u00a7r").append(wanted).append("\u00a7r\n");
        }
        return StringUtils.chomp((String)wantedListMerged.toString());
    }

    public static String getHousePlayers(ServerPlayer sp) {
        House house = HouseManager.getPlayerHouse((Player)sp);
        if (house.isNull()) {
            return Component.m_237115_((String)"translation.key.player_free").getString();
        }
        ArrayList<String> housePlayers = HouseManager.getHousePlayers(sp);
        StringBuilder playerListMerged = new StringBuilder(Component.m_237115_((String)"house.get_house_players").getString() + house.getHouseTitleWithColor() + "\u00a7r: ");
        if (!housePlayers.isEmpty()) {
            playerListMerged.append('\n');
        }
        for (String housePlayer : housePlayers) {
            playerListMerged.append("\u00a7r").append(housePlayer).append("\u00a7r\n");
        }
        return StringUtils.chomp((String)playerListMerged.toString());
    }

    public static String getDomainPlayers(String knightUUID) {
        ArrayList<String> domainPlayers = HouseManager.getDomainPlayers(knightUUID);
        StringBuilder domainPlayersMerged = new StringBuilder(Component.m_237115_((String)"house.get_domain_players").getString());
        if (!domainPlayers.isEmpty()) {
            domainPlayersMerged.append('\n');
        }
        for (String wanted : domainPlayers) {
            domainPlayersMerged.append("\u00a7r").append(wanted).append("\u00a7r\n");
        }
        return StringUtils.chomp((String)domainPlayersMerged.toString());
    }

    public static String getDomainSuspectPlayers(String knightUUID, int count) {
        ArrayList<String> suspectList = HouseManager.getDomainSuspectPlayers(knightUUID, count);
        StringBuilder suspectListMerged = new StringBuilder(Component.m_237115_((String)"house.get_domain_suspect").getString());
        if (!suspectList.isEmpty()) {
            suspectListMerged.append('\n');
        }
        for (String wanted : suspectList) {
            suspectListMerged.append("\u00a7r").append(wanted).append("\u00a7r\n");
        }
        return StringUtils.chomp((String)suspectListMerged.toString());
    }
}

