/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.house;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.mcreator.reignmod.basics.ReignCommon;
import net.mcreator.reignmod.claim.capital.CapitalClaimManager;
import net.mcreator.reignmod.house.Domain;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseNeedType;
import net.mcreator.reignmod.house.HouseSavedData;
import net.mcreator.reignmod.init.ReignModModBlocks;
import net.mcreator.reignmod.network.ReignModModVariables;
import net.mcreator.reignmod.networking.ReignNetworking;
import net.mcreator.reignmod.networking.packet.S2C.PlayerPrefixSyncS2CPacket;
import net.mcreator.reignmod.procedures.HouseDeleteProcedure;
import net.mcreator.reignmod.procedures.IsKingProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.ModList;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public class HouseManager {
    private static final HashMap<String, String> colorCodes = HouseManager.fillColorCodes();

    private static HashMap<String, String> fillColorCodes() {
        HashMap<String, String> colorCodes = new HashMap<String, String>();
        List<String> colors = List.of("yellow", "lime", "green", "aqua", "blue", "purple", "pink", "red", "orange", "black");
        List<String> codes = List.of("\u00a7e", "\u00a7a", "\u00a72", "\u00a7b", "\u00a79", "\u00a75", "\u00a7d", "\u00a7c", "\u00a76", "\u00a78");
        Iterator<String> colorsIterator = colors.iterator();
        Iterator<String> codesIterator = codes.iterator();
        while (colorsIterator.hasNext() && codesIterator.hasNext()) {
            colorCodes.put(colorsIterator.next(), codesIterator.next());
        }
        return colorCodes;
    }

    public static int getIntColorFromName(String name) {
        DyeColor dye;
        if (name == null) {
            return 0xFFFFFF;
        }
        if (name.equalsIgnoreCase("aqua")) {
            dye = DyeColor.LIGHT_BLUE;
        } else {
            try {
                dye = DyeColor.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                dye = DyeColor.WHITE;
            }
        }
        return dye.m_41070_() & 0xFFFFFF;
    }

    public static Collection<House> getHouses() {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHouses().values();
        }
        return new ArrayList<House>();
    }

    public static Collection<House> getHousesCopies() {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            Collection<House> houses = houseSavedData.getHouseData().getHouses().values();
            ArrayList<House> housesCopies = new ArrayList<House>();
            houses.forEach(house -> housesCopies.add(new House(house.serializeNBT())));
            return housesCopies;
        }
        return new ArrayList<House>();
    }

    public static int getHousesCount() {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHouses().size();
        }
        return 0;
    }

    public static boolean createHouse(Player lordPlayer, String houseTitle, String houseColor) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.addHouse(lordPlayer.m_20149_(), houseTitle, houseColor);
        }
        return false;
    }

    public static boolean createDomain(Player lordPlayer, Player knightPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.addDomain(lordPlayer.m_20149_(), knightPlayer.m_20149_(), knightPlayer.m_5446_().getString());
        }
        return false;
    }

    public static void deleteHouse(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            HouseDeleteProcedure.execute((LevelAccessor)HouseSavedData.getServerInstance(), HouseManager.getHouseByLordUUID(lordUUID).getHouseTitleWithColor());
            houseSavedData.removeHouse(lordUUID);
        }
    }

    public static void deleteDomain(Player lordPlayer, Player knightPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.removeDomain(lordPlayer.m_20149_(), knightPlayer.m_20149_());
        }
    }

    public static void deleteDomain(Player knightPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.removeDomain(HouseManager.getDomainLordByKnight(knightPlayer.m_20149_()), knightPlayer.m_20149_());
        }
    }

    public static boolean pushPlayerToDomain(Player knightPlayer, Player player) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.pushPlayerToDomain(knightPlayer.m_20149_(), player.m_20149_());
        }
        return false;
    }

    public static void removePlayerFromDomain(Player player) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            String suzerainUUID = HouseManager.getPlayerSuzerain(player);
            houseSavedData.removePlayerFromDomain(suzerainUUID, player.m_20149_());
        }
    }

    public static boolean removePlayerFromDomain(String knightUUID, String playerName) {
        UUID found;
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null && (found = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName)) != null) {
            houseSavedData.removePlayerFromDomain(knightUUID, found.toString());
            return true;
        }
        return false;
    }

    public static removeDirectVassalResult removeDirectVassal(String suzerainUUID, String playerName) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            Domain playerDomain;
            Domain foundDomain = houseSavedData.getHouseData().findDomainByKnight(suzerainUUID);
            House foundHouse = houseSavedData.getHouseData().findHouseByLord(suzerainUUID);
            UUID foundPlayerUUID = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName);
            String foundPlayerStringUUID = null;
            if (foundPlayerUUID == null) {
                if (!foundHouse.isNull()) {
                    for (String player : foundHouse.getPlayers()) {
                        if (!HouseManager.getOfflinePlayerName(player).equals(playerName)) continue;
                        foundPlayerStringUUID = player;
                    }
                } else if (!foundDomain.isNull()) {
                    for (String player : foundDomain.getPlayers()) {
                        if (!HouseManager.getOfflinePlayerName(player).equals(playerName)) continue;
                        foundPlayerStringUUID = player;
                    }
                }
                if (foundPlayerStringUUID == null) {
                    return removeDirectVassalResult.PLAYER_NOT_FOUND;
                }
            } else {
                foundPlayerStringUUID = foundPlayerUUID.toString();
            }
            if (foundPlayerStringUUID.equals(suzerainUUID)) {
                return removeDirectVassalResult.TRY_TO_KICK_YOURSELF;
            }
            if (!foundHouse.isNull() && !(playerDomain = houseSavedData.getHouseData().findDomainByKnight(foundPlayerStringUUID)).isNull() && playerDomain.getLordUUID().equals(suzerainUUID)) {
                if (playerDomain.getClaimId() != null) {
                    return removeDirectVassalResult.DOMAIN_IS_PROTECTED;
                }
                houseSavedData.removeDomain(suzerainUUID, foundPlayerStringUUID);
                return removeDirectVassalResult.SUCCESS;
            }
            if (!foundDomain.isNull() && foundDomain.getPlayers().contains(foundPlayerStringUUID)) {
                houseSavedData.removePlayerFromDomain(suzerainUUID, foundPlayerStringUUID);
                return removeDirectVassalResult.SUCCESS;
            }
        }
        return removeDirectVassalResult.INSUFFICIENT_AUTHORITY;
    }

    public static boolean addWantedPlayer(String lordUUID, String playerName) {
        UUID found;
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null && (found = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName)) != null) {
            houseSavedData.addWantedPlayer(lordUUID, found.toString());
            return true;
        }
        return false;
    }

    public static boolean removeWantedPlayer(String lordUUID, String playerName) {
        UUID found;
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null && (found = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName)) != null) {
            houseSavedData.removeWantedPlayer(lordUUID, found.toString());
            return true;
        }
        return false;
    }

    public static boolean isPlayerLord(Player lordPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return !houseSavedData.getHouseData().findHouseByLord(lordPlayer.m_20149_()).isNull();
        }
        return false;
    }

    public static boolean isPlayerKnight(Player knightPlayer) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return !houseSavedData.getHouseData().findDomainByKnight(knightPlayer.m_20149_()).isNull();
        }
        return false;
    }

    public static boolean isColorAvailable(String color) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.isColorAvailable(color);
        }
        return false;
    }

    public static House getHouseByLordUUID(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().findHouseByLord(lordUUID);
        }
        return new House();
    }

    public static Domain getDomainByKnightUUID(String knightUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().findDomainByKnight(knightUUID);
        }
        return new Domain();
    }

    public static String getPlayerSuzerain(Player player) {
        return ((ReignModModVariables.PlayerVariables)player.getCapability(ReignModModVariables.PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new ReignModModVariables.PlayerVariables())).house;
    }

    public static String getPlayerDisplayName(Player player) {
        String displayNameWithPrefix = player.m_5446_().getString();
        int playerNameLength = player.m_7755_().getString().length();
        return displayNameWithPrefix.substring(displayNameWithPrefix.length() - playerNameLength);
    }

    public static void playerPrefixSynchronize(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            HouseManager.playerPrefixSynchronize((Player)sp, sp.f_8941_.m_9290_());
        }
    }

    public static void playerPrefixSynchronize(Player player, GameType gameType) {
        Object colorPrefix = HouseManager.getPlayerHouseColorCode(player);
        if (!Objects.equals(colorPrefix, "")) {
            if (IsKingProcedure.execute((LevelAccessor)player.m_20193_(), (Entity)player)) {
                colorPrefix = "\u00a7r[\u00a76\ud83d\udc51\u00a7r] " + (String)colorPrefix + "\u00a7l";
            } else if (HouseManager.isPlayerLord(player)) {
                colorPrefix = "\u00a7r[" + (String)colorPrefix + "\ud83c\udff0\u00a7r] " + (String)colorPrefix + "\u00a7l";
            } else if (HouseManager.isPlayerKnight(player)) {
                colorPrefix = "\u00a7r[" + (String)colorPrefix + "\ud83d\udde1\u00a7r] " + (String)colorPrefix;
            }
        }
        String prefix = "";
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.m_20194_().m_6846_().m_11303_(sp.m_36316_())) {
                prefix = ReignCommon.opPrefix;
            } else if (gameType.equals((Object)GameType.ADVENTURE)) {
                prefix = ReignCommon.travelerPrefix;
            }
        }
        String finalPlayerPrefix = prefix + (String)colorPrefix;
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        houseSavedData.getHouseData().addOrUpdatePlayerCode(player.m_20149_(), finalPlayerPrefix);
        player.getCapability(ReignModModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
            capability.player_prefix = finalPlayerPrefix;
            capability.syncPlayerVariables((Entity)player);
        });
        if (player instanceof ServerPlayer) {
            ReignNetworking.sendToPlayer(new PlayerPrefixSyncS2CPacket(houseSavedData.getHouseData().getPlayerCodes()), (ServerPlayer)player);
        }
        player.refreshDisplayName();
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).refreshTabListName();
        }
    }

    public static void allPlayersPrefixPacketSend() {
        ServerLevel serverInstance = HouseSavedData.getServerInstance();
        serverInstance.m_8795_(serverPlayer -> true).forEach(serverPlayer -> {
            HouseSavedData houseSavedData = HouseSavedData.getInstance();
            ReignNetworking.sendToPlayer(new PlayerPrefixSyncS2CPacket(houseSavedData.getHouseData().getPlayerCodes()), serverPlayer);
        });
    }

    public static House getPlayerHouse(Player player) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            String suzerainUUID = HouseManager.getPlayerSuzerain(player);
            return houseSavedData.getPlayerHouse(suzerainUUID);
        }
        return new House();
    }

    public static House getHouseBySuzerainUUID(String suzerainUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return HouseSavedData.getInstance().getHouseData().findHouseByPlayerSuzerain(suzerainUUID);
        }
        return new House();
    }

    public static String getPlayerHouseTitle(Player player) {
        return HouseManager.getPlayerHouse(player).getHouseTitle();
    }

    public static String getPlayerHouseColor(Player player) {
        return HouseManager.getPlayerHouse(player).getHouseColor();
    }

    public static String getPlayerHouseColorCode(Player player) {
        return colorCodes.getOrDefault(HouseManager.getPlayerHouseColor(player), "");
    }

    public static String getHouseColorCode(String color) {
        return colorCodes.getOrDefault(color, "");
    }

    public static String getPlayerHouseLord(Player player) {
        return HouseManager.getPlayerHouse(player).getLordUUID();
    }

    public static int getHouseDomainCount(Player player) {
        return HouseManager.getPlayerHouse(player).getDomains().size();
    }

    public static int getHousePlayerCount(Player player) {
        return HouseManager.getPlayerHouse(player).getPlayers().size();
    }

    public static ArrayList<String> getHouseWantedPlayers(ServerPlayer serverPlayer) {
        HashSet<String> found = HouseManager.getPlayerHouse((Player)serverPlayer).getWantedPlayers();
        ArrayList<String> domainWantedPlayers = new ArrayList<String>(found.size());
        found.forEach(sus -> domainWantedPlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(sus, "") + HouseManager.getOfflinePlayerName(sus)));
        return domainWantedPlayers;
    }

    public static Domain getPlayerDomain(Player player) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            String suzerainUUID = HouseManager.getPlayerSuzerain(player);
            return houseSavedData.getPlayerDomain(player.m_20149_(), suzerainUUID);
        }
        return new Domain();
    }

    public static String getDomainLordByKnight(String knightUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().findDomainByKnight(knightUUID).getLordUUID();
        }
        return null;
    }

    public static String getPlayerDomainTitle(Player player) {
        return HouseManager.getPlayerDomain(player).getDomainTitle().getString();
    }

    public static String getPlayerDomainKnight(Player player) {
        return HouseManager.getPlayerDomain(player).getKnightUUID();
    }

    public static int getDomainPlayerCount(Player player) {
        return HouseManager.getPlayerDomain(player).getPlayers().size();
    }

    public static int getDomainCount() {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getDomains().size();
        }
        return -1;
    }

    public static ArrayList<String> getHousePlayers(ServerPlayer serverPlayer) {
        House house = HouseManager.getPlayerHouse((Player)serverPlayer);
        if (house.isNull()) {
            return new ArrayList<String>();
        }
        String lordUUID = house.getLordUUID();
        ArrayList<String> housePlayers = new ArrayList<String>(house.getPlayers().size());
        housePlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(lordUUID, "") + HouseManager.getOfflinePlayerName(lordUUID));
        HouseManager.getDomainByKnightUUID(lordUUID).getPlayers().forEach(pl -> {
            if (pl.equals(lordUUID)) {
                return;
            }
            housePlayers.add("- " + HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(pl, "") + HouseManager.getOfflinePlayerName(pl));
        });
        house.getDomains().forEach((knightID, domain) -> {
            if (knightID.equals(lordUUID)) {
                return;
            }
            housePlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(knightID, "") + HouseManager.getOfflinePlayerName(knightID));
            domain.getPlayers().forEach(pl -> {
                if (pl.equals(knightID)) {
                    return;
                }
                housePlayers.add("- " + HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(pl, "") + HouseManager.getOfflinePlayerName(pl));
            });
        });
        return housePlayers;
    }

    public static ArrayList<String> getDomainPlayers(String knightUUID) {
        HashSet<String> found = HouseManager.getDomainByKnightUUID(knightUUID).getPlayers();
        ArrayList<String> domainPlayers = new ArrayList<String>(found.size());
        found.forEach(sus -> domainPlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(sus, "") + HouseManager.getOfflinePlayerName(sus)));
        return domainPlayers;
    }

    public static ArrayList<String> getDomainSuspectPlayers(String knightUUID, int count) {
        List<Map.Entry<String, Integer>> found = HouseManager.getDomainByKnightUUID(knightUUID).getSortedSuspects(count);
        ArrayList<String> domainSuspectPlayers = new ArrayList<String>(found.size());
        found.forEach(sus -> domainSuspectPlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(sus.getKey(), "") + HouseManager.getOfflinePlayerName((String)sus.getKey()) + "\u00a7r: " + String.valueOf(sus.getValue())));
        return domainSuspectPlayers;
    }

    public static ArrayList<String> getIlyaDomainSuspectPlayers(String knightUUID, int count) {
        List<Map.Entry<String, Integer>> found = HouseManager.getDomainByKnightUUID(knightUUID).getSortedSuspects(count);
        ArrayList<String> domainSuspectPlayers = new ArrayList<String>(found.size());
        found.forEach(sus -> {
            domainSuspectPlayers.add(HouseSavedData.getInstance().getHouseData().getPlayerCodes().getOrDefault(sus.getKey(), "") + HouseManager.getOfflinePlayerName((String)sus.getKey()));
            domainSuspectPlayers.add(String.valueOf(sus.getValue()));
        });
        while (domainSuspectPlayers.size() < count * 2) {
            domainSuspectPlayers.add("");
        }
        return domainSuspectPlayers;
    }

    public Optional<Boolean> getDomainDebuff(String lordUUID, String knightUUID, Domain.DomainDebuffs debuff) {
        return HouseManager.getHouseByLordUUID(lordUUID).getDebuff(knightUUID, debuff);
    }

    public boolean toggleOnDebuff(String lordUUID, String knightUUID, Domain.DomainDebuffs debuff) {
        return HouseManager.getHouseByLordUUID(lordUUID).toggleOnDebuff(knightUUID, debuff);
    }

    public boolean toggleOffDebuff(String lordUUID, String knightUUID, Domain.DomainDebuffs debuff) {
        return HouseManager.getHouseByLordUUID(lordUUID).toggleOffDebuff(knightUUID, debuff);
    }

    private static int[] getHousePlusCoordinates(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHousePlusCoordinates(lordUUID);
        }
        return new int[]{0, 0, 0};
    }

    public static boolean isHousePlusNull(String lordUUID) {
        return Arrays.equals(HouseManager.getHousePlusCoordinates(lordUUID), new int[]{0, 0, 0});
    }

    public static int getHousePlusX(String lordUUID) {
        return HouseManager.getHousePlusCoordinates(lordUUID)[0];
    }

    public static int getHousePlusY(String lordUUID) {
        return HouseManager.getHousePlusCoordinates(lordUUID)[1];
    }

    public static int getHousePlusZ(String lordUUID) {
        return HouseManager.getHousePlusCoordinates(lordUUID)[2];
    }

    public static void setHousePlusCoordinates(String lordUUID, int x, int y, int z) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.getHouseData().setHousePlusCoordinates(lordUUID, x, y, z);
            houseSavedData.m_77762_();
        }
    }

    private static int[] getHouseIncubatorCoordinates(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHouseIncubatorCoordinates(lordUUID);
        }
        return new int[]{0, 0, 0};
    }

    public static boolean isHouseIncubatorNull(String lordUUID) {
        return Arrays.equals(HouseManager.getHouseIncubatorCoordinates(lordUUID), new int[]{0, 0, 0});
    }

    public static int getHouseIncubatorX(String lordUUID) {
        return HouseManager.getHouseIncubatorCoordinates(lordUUID)[0];
    }

    public static int getHouseIncubatorY(String lordUUID) {
        return HouseManager.getHouseIncubatorCoordinates(lordUUID)[1];
    }

    public static int getHouseIncubatorZ(String lordUUID) {
        return HouseManager.getHouseIncubatorCoordinates(lordUUID)[2];
    }

    public static void setHouseIncubatorCoordinates(String lordUUID, int x, int y, int z) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.getHouseData().setHouseIncubatorCoordinates(lordUUID, x, y, z);
            houseSavedData.m_77762_();
        }
    }

    private static int[] getHousePrisonCoordinates(String lordUUID) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            return houseSavedData.getHouseData().getHousePrisonCoordinates(lordUUID);
        }
        return new int[]{0, 0, 0};
    }

    public static boolean isHousePrisonNull(String lordUUID) {
        return Arrays.equals(HouseManager.getHousePrisonCoordinates(lordUUID), new int[]{0, 0, 0});
    }

    public static int getHousePrisonX(String lordUUID) {
        return HouseManager.getHousePrisonCoordinates(lordUUID)[0];
    }

    public static int getHousePrisonY(String lordUUID) {
        return HouseManager.getHousePrisonCoordinates(lordUUID)[1];
    }

    public static int getHousePrisonZ(String lordUUID) {
        return HouseManager.getHousePrisonCoordinates(lordUUID)[2];
    }

    public void setHousePrisonCoordinates(String lordUUID, int x, int y, int z) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        if (houseSavedData != null) {
            houseSavedData.getHouseData().setHousePrisonCoordinates(lordUUID, x, y, z);
            houseSavedData.m_77762_();
        }
    }

    public static int getHouseNeed(ServerPlayer player, HouseNeedType type) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        return houseSavedData.getHouseNeed(player.m_20149_(), type);
    }

    public static void setHouseNeed(ServerPlayer player, HouseNeedType type, int value) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        houseSavedData.setHouseNeed(player.m_20149_(), type, value);
    }

    public static int adjustHouseNeed(ServerPlayer player, HouseNeedType type, int delta) {
        HouseSavedData houseSavedData = HouseSavedData.getInstance();
        return houseSavedData.adjustHouseNeed(player.m_20149_(), type, delta);
    }

    public static double getCurseCoefficient(int lvl) {
        return switch (lvl) {
            case 1 -> 20.0;
            case 2 -> 8.0;
            case 3 -> 3.0;
            case 4 -> 2.0;
            case 5 -> 1.8;
            case 6 -> 1.6;
            case 7 -> 1.5;
            case 8 -> 1.4;
            case 9 -> 1.3;
            case 10 -> 1.2;
            default -> 1.0;
        };
    }

    public static void feedHouses() {
        ArrayList<String> houses_to_delete = new ArrayList<String>();
        Collection<House> houses = HouseManager.getHouses();
        for (House house : houses) {
            int need_jewelry;
            int need_sweets;
            int need_wool;
            int need_meat;
            int need_roots;
            Collection<Domain> domains = house.getDomains().values();
            int lvl = house.getHouseLevel();
            int add_hp = -70 - lvl * 12;
            if (house.getPlayers().size() < 3) {
                add_hp -= 100;
            }
            int[] incubator = house.getHouseIncubatorCoordinates();
            if (!HouseSavedData.getServerInstance().m_8055_(new BlockPos(incubator[0], incubator[1], incubator[2])).m_60734_().equals(ReignModModBlocks.INCUBATOR.get())) {
                add_hp -= 100;
            }
            int coalMult = 1;
            int foodMult = 1;
            if (ModList.get().isLoaded("sereneseasons")) {
                Season season = SeasonHelper.getSeasonState((Level)HouseSavedData.getServerInstance()).getSubSeason().getSeason();
                if (season.equals((Object)Season.WINTER)) {
                    coalMult = 3;
                    foodMult = 2;
                } else if (season.equals((Object)Season.SPRING) || season.equals((Object)Season.AUTUMN)) {
                    coalMult = 2;
                }
            }
            if (house.isWarStateEnabled()) {
                coalMult *= 2;
                foodMult *= 2;
            }
            int need_fuel = (int)((double)(domains.size() * 2 * coalMult) * (house.isCursed() ? HouseManager.getCurseCoefficient(lvl) : 1.0));
            int need_bread = (int)((double)(house.getPlayers().size() * foodMult) * (house.isCursed() ? HouseManager.getCurseCoefficient(lvl) : 1.0));
            int n = lvl >= 3 ? (int)((double)(house.getPlayers().size() * foodMult) * (house.isCursed() ? HouseManager.getCurseCoefficient(lvl) : 1.0)) : (need_roots = 0);
            int n2 = lvl >= 4 ? (int)((double)(domains.size() * foodMult) * (house.isCursed() ? HouseManager.getCurseCoefficient(lvl) : 1.0)) : (need_meat = 0);
            int n3 = lvl >= 5 ? (int)((double)(domains.size() * coalMult) * (house.isCursed() ? HouseManager.getCurseCoefficient(lvl) : 1.0)) : (need_wool = 0);
            int n4 = lvl >= 6 ? (int)(2.0 * (house.isCursed() ? HouseManager.getCurseCoefficient(lvl) : 1.0)) : (need_sweets = 0);
            int n5 = lvl >= 7 ? (int)(2.0 * (house.isCursed() ? HouseManager.getCurseCoefficient(lvl) : 1.0)) : (need_jewelry = 0);
            if (house.getNeed(HouseNeedType.FUEL) >= need_fuel) {
                add_hp += 50;
            }
            house.adjustNeed(HouseNeedType.FUEL, -need_fuel);
            if (house.getNeed(HouseNeedType.BREAD) >= need_bread) {
                add_hp += 50;
            }
            house.adjustNeed(HouseNeedType.BREAD, -need_bread);
            if (house.getNeed(HouseNeedType.ROOTS) >= need_roots && lvl >= 3) {
                add_hp += 20;
            }
            house.adjustNeed(HouseNeedType.ROOTS, -need_roots);
            if (house.getNeed(HouseNeedType.MEAT) >= need_meat && lvl >= 4) {
                add_hp += 20;
            }
            house.adjustNeed(HouseNeedType.MEAT, -need_meat);
            if (house.getNeed(HouseNeedType.WOOL) >= need_wool && lvl >= 5) {
                add_hp += 10;
            }
            house.adjustNeed(HouseNeedType.WOOL, -need_wool);
            if (house.getNeed(HouseNeedType.SWEETS) >= need_sweets && lvl >= 6) {
                add_hp += 10;
            }
            house.adjustNeed(HouseNeedType.SWEETS, -need_sweets);
            if (house.getNeed(HouseNeedType.JEWELRY) >= need_jewelry && lvl >= 7) {
                add_hp += 10;
            }
            house.adjustNeed(HouseNeedType.JEWELRY, -need_jewelry);
            int add_from_domains = 0;
            for (Domain domain : domains) {
                domain.adjustSuspicionForAll(-1);
                HouseManager.damageDomain(domain);
                HouseManager.chanceDomainEvents(domain);
                add_from_domains += 3 * (domain.getDomainHP() / 300);
            }
            if ((add_hp += add_from_domains) < 0) {
                HouseManager.getOnlinePlayerByUUID(house.getLordUUID()).ifPresent(serverPlayer -> {
                    serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 2, false, true, true));
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"translation.key.house_starving"), false);
                });
            }
            if (house.isSiegeStateEnabled()) {
                if (house.addHouseHP(Math.max(-20, Math.min(add_hp, -5))) == 0) {
                    houses_to_delete.add(house.getLordUUID());
                }
            } else if (house.addHouseHP(Math.max(-40, Math.min(add_hp, 40))) == 0) {
                houses_to_delete.add(house.getLordUUID());
            }
            house.decreaseCurseHours(1);
            house.warStateCheck();
            HouseSavedData.getInstance().m_77762_();
            house.updateIncubatorInfo();
        }
        houses_to_delete.forEach(HouseManager::deleteHouse);
    }

    private static void damageDomain(Domain domain) {
        int add = 2;
        if (domain.getDebuff(Domain.DomainDebuffs.disease).booleanValue()) {
            add -= 4;
        }
        if (domain.getDebuff(Domain.DomainDebuffs.robbers).booleanValue()) {
            add -= 7;
        }
        domain.addDomainHP(add);
    }

    private static void chanceDomainEvents(Domain domain) {
        int x = (int)(Math.random() * 1000.0) + 1;
        if (x == 1) {
            domain.toggleOnDebuff(Domain.DomainDebuffs.robbers);
        }
        if ((x = (int)(Math.random() * 100.0) + 1) == 1) {
            domain.toggleOffDebuff(Domain.DomainDebuffs.disease);
        }
    }

    public static String getOfflinePlayerName(String playerUUID) {
        String playerName = UsernameCache.getLastKnownUsername((UUID)UUID.fromString(playerUUID));
        if (playerName != null) {
            return playerName;
        }
        return "";
    }

    public static Optional<ServerPlayer> getOnlinePlayerByUUID(String playerUUID) {
        return Optional.ofNullable(HouseSavedData.getServerInstance().m_7654_().m_6846_().m_11259_(UUID.fromString(playerUUID)));
    }

    public static Optional<String> getOfflinePlayerDisplayName(String playerName) {
        UUID found = CapitalClaimManager.getOfflinePlayerUUID(HouseSavedData.getServerInstance().m_7654_(), playerName);
        if (found != null) {
            return Optional.ofNullable(HouseSavedData.getInstance().getHouseData().getPlayerCodes().get(found.toString()));
        }
        return Optional.empty();
    }

    public static int getWorldInfluence() {
        int wolrdInfluence = 0;
        for (House house : HouseManager.getHouses()) {
            wolrdInfluence += house.getInfluence();
        }
        return wolrdInfluence;
    }

    public static enum removeDirectVassalResult {
        PLAYER_NOT_FOUND,
        INSUFFICIENT_AUTHORITY,
        DOMAIN_IS_PROTECTED,
        TRY_TO_KICK_YOURSELF,
        SUCCESS;

    }
}

