/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.mines;

import java.util.Map;
import java.util.Optional;
import net.mcreator.reignmod.init.ReignModModBlocks;
import net.mcreator.reignmod.mines.MineChunkData;
import net.mcreator.reignmod.mines.MineConstants;
import net.mcreator.reignmod.mines.MineData;
import net.mcreator.reignmod.mines.MineRichness;
import net.mcreator.reignmod.mines.MineSavedData;
import net.mcreator.reignmod.mines.MineType;
import net.mcreator.reignmod.mines.MineUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MineManager {
    public static Optional<MineData> tryCreateMine(ChunkPos chunkPos) {
        return MineUtils.tryGenerateMine(MineSavedData.getServerInstance(), chunkPos, MineSavedData.getRandom());
    }

    public static Optional<MineType> getMineType(ChunkPos chunkPos) {
        Optional<MineData> mineDataOpt = MineSavedData.getInstance().getMineData().getMine(chunkPos);
        return mineDataOpt.map(MineData::getType);
    }

    public static Optional<Double> getMineCapacity(ChunkPos chunkPos) {
        Optional<MineData> mineDataOpt = MineSavedData.getInstance().getMineData().getMine(chunkPos);
        return mineDataOpt.map(MineData::getCapacity);
    }

    public static SetMineResult setMineBlockPos(BlockPos blockPos) {
        MineSavedData saved = MineSavedData.getInstance();
        ServerLevel level = saved.getServerLevelInstance();
        if (MineUtils.calculateSkyVisibility(level, blockPos) < 1.0f) {
            return SetMineResult.SKY_NOT_CLEAR;
        }
        ChunkPos chunkPos = new ChunkPos(blockPos);
        MineChunkData data = saved.getMineData();
        Optional<MineData> mineOpt = data.getMine(chunkPos);
        if (mineOpt.isEmpty()) {
            return SetMineResult.MINE_NOT_FOUND;
        }
        MineData mine = mineOpt.get();
        if (mine.getMineBlockPos() != null) {
            return SetMineResult.POSITION_ALREADY_SET;
        }
        mine.setMineBlockPos(blockPos);
        Optional<BlockEntity> be_opt = data.getMineBlockEntity(level, chunkPos);
        be_opt.ifPresent(be -> {
            be.getPersistentData().m_128359_("type", mine.getType().name());
            be.m_6596_();
        });
        saved.m_77762_();
        return SetMineResult.SUCCESS;
    }

    public static boolean extract(ChunkPos chunkPos) {
        MineSavedData saved = MineSavedData.getInstance();
        MineChunkData data = saved.getMineData();
        ServerLevel level = saved.getServerLevelInstance();
        Optional<MineData> opt = data.getMine(chunkPos);
        if (opt.isEmpty()) {
            return false;
        }
        MineData mine = opt.get();
        BlockPos blockPos = mine.getMineBlockPos();
        if (blockPos == null) {
            return false;
        }
        if (!level.m_8055_(blockPos).m_60734_().equals(ReignModModBlocks.MINE.get())) {
            saved.clearAssignmentsForChunk(chunkPos);
            mine.setMineBlockPos(null);
            MineSavedData.getInstance().m_77762_();
            return false;
        }
        Optional<BlockEntity> be_opt = data.getMineBlockEntity(level, chunkPos);
        if (be_opt.isEmpty()) {
            saved.clearAssignmentsForChunk(chunkPos);
            mine.setMineBlockPos(null);
            MineSavedData.getInstance().m_77762_();
            return false;
        }
        BlockEntity be = be_opt.get();
        float skyRatio = MineUtils.calculateSkyVisibility(level, blockPos);
        if (skyRatio == 0.0f) {
            return false;
        }
        CompoundTag pd = be.getPersistentData();
        double hours = pd.m_128459_("remainingHours");
        if (hours <= 0.0) {
            saved.clearAssignmentsForChunk(chunkPos);
            pd.m_128347_("remainingHours", 0.0);
            pd.m_128347_("workerCount", 0.0);
            be.m_6596_();
            MineSavedData.getInstance().m_77762_();
            return false;
        }
        pd.m_128347_("remainingHours", hours - 1.0);
        be.m_6596_();
        int workerCount = (int)pd.m_128459_("workerCount");
        double efficiency = (double)workerCount / 4.0;
        if (efficiency <= 0.0) {
            return false;
        }
        double richMultiplier = mine.getRichness() == MineRichness.RICH ? 1.5 : 1.0;
        double base = MineConstants.BASE_YIELDS.getOrDefault((Object)mine.getType(), 1.0);
        double amount = Math.max(0.0, base * (double)skyRatio * efficiency * richMultiplier);
        double extracted = Math.min(amount, mine.getCapacity());
        mine.reduceCapacity(extracted);
        pd.m_128347_("oreLeft", mine.getCapacity());
        pd.m_128347_("stored", pd.m_128459_("stored") + extracted);
        be.m_6596_();
        if (mine.getCapacity() <= 0.0) {
            saved.clearAssignmentsForChunk(chunkPos);
            data.removeMine(chunkPos);
        }
        saved.m_77762_();
        return true;
    }

    public static AddWorkerResult addWorker(ServerPlayer player, ChunkPos chunkPos) {
        String uuid = player.m_20148_().toString();
        MineSavedData saved = MineSavedData.getInstance();
        ServerLevel level = saved.getServerLevelInstance();
        Map<String, ChunkPos> assignments = saved.getPlayerAssignments();
        if (!MineUtils.isSerf(player)) {
            return AddWorkerResult.NOT_SERF;
        }
        if (!MineUtils.isOnPlayerDomain(player, chunkPos)) {
            return AddWorkerResult.NOT_ON_DOMAIN;
        }
        if (assignments.containsKey(uuid)) {
            return AddWorkerResult.ALREADY_WORKING;
        }
        MineChunkData data = saved.getMineData();
        Optional<MineData> mineOpt = data.getMine(chunkPos);
        if (mineOpt.isEmpty()) {
            return AddWorkerResult.MINE_NOT_FOUND;
        }
        MineData mine = mineOpt.get();
        BlockPos pos = mine.getMineBlockPos();
        if (pos == null) {
            return AddWorkerResult.POSITION_NOT_SET;
        }
        if (!level.m_8055_(pos).m_60734_().equals(ReignModModBlocks.MINE.get())) {
            return AddWorkerResult.NOT_MINE_ON_CORDS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be == null) {
            return AddWorkerResult.NO_BLOCK_ENTITY;
        }
        CompoundTag pd = be.getPersistentData();
        double workerCount = pd.m_128459_("workerCount");
        double remainingHours = pd.m_128459_("remainingHours");
        if (workerCount >= 4.0) {
            return AddWorkerResult.TOO_MANY_WORKERS;
        }
        pd.m_128347_("workerCount", workerCount += 1.0);
        pd.m_128347_("remainingHours", remainingHours += 12.0);
        be.m_6596_();
        assignments.put(uuid, chunkPos);
        saved.m_77762_();
        return AddWorkerResult.SUCCESS;
    }

    public static void extractAll() {
        MineSavedData saved = MineSavedData.getInstance();
        MineChunkData data = saved.getMineData();
        for (ChunkPos chunkPos : data.getMines().keySet()) {
            MineManager.extract(chunkPos);
        }
    }

    public static enum SetMineResult {
        SUCCESS,
        SKY_NOT_CLEAR,
        MINE_NOT_FOUND,
        POSITION_ALREADY_SET;

    }

    public static enum AddWorkerResult {
        SUCCESS,
        NOT_SERF,
        NOT_ON_DOMAIN,
        ALREADY_WORKING,
        MINE_NOT_FOUND,
        POSITION_NOT_SET,
        NOT_MINE_ON_CORDS,
        NO_BLOCK_ENTITY,
        TOO_MANY_WORKERS;

    }
}

