/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reignmod.mines;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.mcreator.reignmod.claim.chunk.ChunkClaimManager;
import net.mcreator.reignmod.claim.chunk.ChunkClaimSavedData;
import net.mcreator.reignmod.house.Domain;
import net.mcreator.reignmod.house.House;
import net.mcreator.reignmod.house.HouseManager;
import net.mcreator.reignmod.mines.MineChunkData;
import net.mcreator.reignmod.mines.MineConstants;
import net.mcreator.reignmod.mines.MineData;
import net.mcreator.reignmod.mines.MineRichness;
import net.mcreator.reignmod.mines.MineSavedData;
import net.mcreator.reignmod.mines.MineType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;

public class MineUtils {
    public static Component getLocalizedBiomeName(ChunkPos pos) {
        ServerLevel level = ChunkClaimSavedData.getServerInstance();
        Holder holder = level.m_204166_(pos.m_151394_(300));
        return (Component)holder.m_203543_().map(key -> {
            ResourceLocation id = key.m_135782_();
            String translationKey = "biome." + id.m_135827_() + "." + id.m_135815_();
            return Component.m_237115_((String)translationKey);
        }).orElse(Component.m_237113_((String)"Unknown"));
    }

    public static float calculateSkyVisibility(ServerLevel level, BlockPos minePos) {
        int checkFromY;
        int visible = 0;
        int total = 49;
        int baseX = minePos.m_123341_();
        int baseY = minePos.m_123342_();
        int non_bedrock_layer = level.m_141937_() + 5;
        int baseZ = minePos.m_123343_();
        int n = checkFromY = minePos.m_123342_() > non_bedrock_layer ? minePos.m_123342_() + 1 : non_bedrock_layer;
        if (!level.m_8055_(new BlockPos(baseX, baseY + 1, baseZ)).m_60734_().equals(Blocks.f_50016_)) {
            return 0.0f;
        }
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                BlockPos pos = new BlockPos(baseX + dx, checkFromY, baseZ + dz);
                if (!level.m_45527_(pos)) continue;
                ++visible;
            }
        }
        return (float)visible / (float)total;
    }

    public static Optional<MineData> tryGenerateMine(ServerLevel level, ChunkPos chunkPos, RandomSource random) {
        MineSavedData saved = MineSavedData.getInstance();
        MineChunkData data = saved.getMineData();
        if (data.isChecked(chunkPos)) {
            return data.getMine(chunkPos);
        }
        data.markChecked(chunkPos);
        BlockPos sample = chunkPos.m_151394_(300);
        Holder biomeHolder = level.m_204166_(sample);
        double d = random.m_188500_();
        double d2 = biomeHolder.m_203656_(BiomeTags.f_207606_) || biomeHolder.m_203656_(BiomeTags.f_207608_) ? 0.02 : 0.007;
        if (d > d2) {
            saved.m_77762_();
            return Optional.empty();
        }
        List<MineType> allowed = MineUtils.getAllowedTypesForBiome((Holder<Biome>)biomeHolder);
        if (allowed.isEmpty()) {
            saved.m_77762_();
            return Optional.empty();
        }
        MineType type = MineUtils.getWeightedRandomType(allowed, random);
        MineRichness richness = random.m_188500_() < 0.2 ? MineRichness.RICH : MineRichness.POOR;
        MineData mine = new MineData(chunkPos, type, richness);
        data.addMine(chunkPos, mine);
        saved.m_77762_();
        return Optional.of(mine);
    }

    public static boolean isSerf(ServerPlayer sp) {
        Domain domain = HouseManager.getDomainByKnightUUID(HouseManager.getPlayerSuzerain((Player)sp));
        return !domain.isNull() && !domain.getKnightUUID().equals(sp.m_20149_()) && domain.getPlayers().contains(sp.m_20149_());
    }

    public static boolean isOnPlayerDomain(ServerPlayer sp, ChunkPos c) {
        House house = HouseManager.getPlayerHouse((Player)sp);
        if (house.isNull()) {
            return false;
        }
        return ChunkClaimManager.isOwnerOfChunk(house.getLordUUID(), c.f_45578_, c.f_45579_);
    }

    private static List<MineType> getAllowedTypesForBiome(Holder<Biome> biome) {
        if (biome.m_203656_(BiomeTags.f_215803_) || biome.m_203656_(BiomeTags.f_207604_) || biome.m_203656_(BiomeTags.f_207612_) || biome.m_203656_(BiomeTags.f_215818_)) {
            return List.of();
        }
        ArrayList<MineType> result = new ArrayList<MineType>();
        result.add(MineType.COPPER);
        result.add(MineType.SOURCE);
        if (biome.m_203656_(BiomeTags.f_207611_) || biome.m_203656_(BiomeTags.f_207609_) || biome.m_203656_(BiomeTags.f_207606_) || biome.m_203656_(BiomeTags.f_215816_)) {
            result.add(MineType.IRON);
        }
        if (biome.m_203656_(BiomeTags.f_207606_) || biome.m_203656_(BiomeTags.f_207607_)) {
            result.add(MineType.GOLD);
        }
        if (biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(BiomeTags.f_207608_)) {
            result.add(MineType.DIAMOND);
        }
        if (biome.m_203656_(BiomeTags.f_207610_) || biome.m_203656_(BiomeTags.f_207606_)) {
            result.add(MineType.EMERALD);
        }
        return result;
    }

    private static MineType getWeightedRandomType(List<MineType> types, RandomSource random) {
        TreeMap<Double, MineType> map = new TreeMap<Double, MineType>();
        double total = 0.0;
        for (MineType type : types) {
            double weight = MineConstants.TYPE_WEIGHTS.getOrDefault((Object)type, 1.0);
            if (weight <= 0.0) continue;
            map.put(total += weight, type);
        }
        double r = random.m_188500_() * total;
        return (MineType)((Object)map.higherEntry(r).getValue());
    }
}

