/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.extensions.client.renderer;

import io.github.mattidragon.extendeddrawers.extensions.ExtendedDrawersExtensions;
import io.github.mattidragon.extendeddrawers.extensions.block.entity.EnderConnectorBlockEntity;
import io.github.mattidragon.extendeddrawers.extensions.client.renderer.state.EnderConnectorRenderState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class EnderConnectorBlockEntityRenderer
implements class_827<EnderConnectorBlockEntity, EnderConnectorRenderState> {
    private static final class_2960 TEXTURE_ID = ExtendedDrawersExtensions.id("textures/entity/ender_connector_beam.png");

    public EnderConnectorBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public EnderConnectorRenderState createRenderState() {
        return new EnderConnectorRenderState();
    }

    public void updateRenderState(EnderConnectorBlockEntity entity, EnderConnectorRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)entity, (class_11954)state, tickProgress, cameraPos, crumblingOverlay);
        state.rays = entity.rayDirectionCache();
    }

    public void render(EnderConnectorRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        matrices.method_22903();
        matrices.method_22904(0.5, 0.5, 0.5);
        int light = state.field_62676;
        for (Vector3f ray : state.rays) {
            float length = ray.length();
            float yaw = (float)Math.atan2(ray.x(), ray.z());
            float pitch = (float)Math.asin(ray.y() / length);
            matrices.method_22904(0.001, 0.001, 0.001);
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)class_7833.field_40716.rotation(yaw));
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotation(-pitch));
            queue.method_73483(matrices, class_1921.method_23580((class_2960)TEXTURE_ID), (matricesEntry, vertexConsumer) -> {
                EnderConnectorBlockEntityRenderer.quad(matricesEntry, vertexConsumer, light, length, -0.1f, 0.1f, 0.1f, 0.1f, new Vector3f(0.0f, 1.0f, 0.0f));
                EnderConnectorBlockEntityRenderer.quad(matricesEntry, vertexConsumer, light, length, -0.1f, 0.1f, -0.1f, -0.1f, new Vector3f(0.0f, -1.0f, 0.0f));
                EnderConnectorBlockEntityRenderer.quad(matricesEntry, vertexConsumer, light, length, -0.1f, -0.1f, -0.1f, 0.1f, new Vector3f(-1.0f, 0.0f, 0.0f));
                EnderConnectorBlockEntityRenderer.quad(matricesEntry, vertexConsumer, light, length, 0.1f, 0.1f, -0.1f, 0.1f, new Vector3f(1.0f, 0.0f, 0.0f));
            });
            matrices.method_22909();
        }
        matrices.method_22909();
    }

    private static void quad(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, int light, float length, float x1, float x2, float y1, float y2, Vector3f normal) {
        float lengthFactor = length / 3.0f;
        vertexConsumer.method_56824(matricesEntry, x1, y1, 0.0f).method_39415(-1).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_61959(matricesEntry, normal);
        vertexConsumer.method_56824(matricesEntry, x2, y2, 0.0f).method_39415(-1).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_61959(matricesEntry, normal);
        vertexConsumer.method_56824(matricesEntry, x2, y2, length).method_39415(-1).method_22913(1.0f * lengthFactor, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_61959(matricesEntry, normal);
        vertexConsumer.method_56824(matricesEntry, x1, y1, length).method_39415(-1).method_22913(1.0f * lengthFactor, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_61959(matricesEntry, normal);
    }
}

