/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.thomilist.dimensionalinventories.compatibility.Compat;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFoundContext;
import net.thomilist.dimensionalinventories.module.ModuleGroup;
import net.thomilist.dimensionalinventories.module.ModuleRegistry;
import net.thomilist.dimensionalinventories.module.base.config.ConfigModule;
import net.thomilist.dimensionalinventories.module.base.player.PlayerModule;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolTransitionHandler;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;
import net.thomilist.dimensionalinventories.module.version.StorageVersionMigration;
import net.thomilist.dimensionalinventories.util.ModProperties;
import net.thomilist.dimensionalinventories.util.SavePaths;
import net.thomilist.dimensionalinventories.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionalInventories
implements ModInitializer {
    public static final DimensionalInventories INSTANCE = new DimensionalInventories();
    public static final ModProperties PROPERTIES = new ModProperties("dimensional-inventories");
    public static final Logger LOGGER = LoggerFactory.getLogger((String)PROPERTIES.namePascal());
    public final StorageVersion storageVersion;
    public final StorageVersionMigration storageVersionMigration;
    public final ModuleRegistry<ConfigModule> configModules = new ModuleRegistry<ConfigModule>(ConfigModule.class);
    public final ModuleRegistry<PlayerModule> playerModules = new ModuleRegistry<PlayerModule>(PlayerModule.class);
    public final DimensionPoolTransitionHandler transitionHandler;

    public DimensionalInventories(StorageVersion storageVersion) {
        this.storageVersion = storageVersion;
        this.transitionHandler = new DimensionPoolTransitionHandler(this.storageVersion, this.configModules, this.playerModules);
        this.storageVersionMigration = new StorageVersionMigration(this.storageVersion, this.configModules, this.transitionHandler);
    }

    public DimensionalInventories() {
        this(StorageVersion.V2);
    }

    public void onInitialize() {
        try (LostAndFoundContext LAF = LostAndFound.init("init", "base", PROPERTIES.id());){
            INSTANCE.registerStartupHandlers();
            INSTANCE.registerPlayerTravelHandler();
            INSTANCE.registerPlayerRespawnHandler();
            INSTANCE.registerEntityTravelHandler();
        }
    }

    public void registerModules(ModuleGroup moduleGroup) {
        LOGGER.info("Registering modules from module group {} ...", (Object)StringHelper.joinAndWrapScopes(moduleGroup.groupId()));
        this.configModules.register(moduleGroup);
        this.playerModules.register(moduleGroup);
    }

    private void registerStartupHandlers() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            try (LostAndFoundContext LAF = LostAndFound.init("server started");){
                Compat.onServerStarted(server);
                SavePaths.onServerStarted(server);
                this.storageVersionMigration.tryMigrate(server);
                for (ConfigModule config : this.configModules.get(StorageVersion.latest())) {
                    config.loadWithContext();
                }
                LOGGER.info("{} {} initialised", (Object)PROPERTIES.namePretty(), (Object)PROPERTIES.version());
            }
        });
    }

    private void registerPlayerTravelHandler() {
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            try (LostAndFoundContext LAF = LostAndFound.init("player changed dimension");){
                String originDimensionName = origin.method_27983().method_29177().toString();
                String destinationDimensionName = destination.method_27983().method_29177().toString();
                this.transitionHandler.handlePlayerDimensionChange(player, originDimensionName, destinationDimensionName);
            }
        });
    }

    private void registerPlayerRespawnHandler() {
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            try (LostAndFoundContext LAF = LostAndFound.init("player respawned");){
                String originDimensionName = Compat.ENTITY.getWorld(oldPlayer).method_27983().method_29177().toString();
                String destinationDimensionName = Compat.ENTITY.getWorld(newPlayer).method_27983().method_29177().toString();
                this.transitionHandler.handlePlayerDimensionChange(newPlayer, originDimensionName, destinationDimensionName);
            }
        });
    }

    private void registerEntityTravelHandler() {
        ServerEntityWorldChangeEvents.AFTER_ENTITY_CHANGE_WORLD.register((originalEntity, newEntity, origin, destination) -> {
            try (LostAndFoundContext LAF = LostAndFound.init("entity changed dimension");){
                String originDimensionName = origin.method_27983().method_29177().toString();
                String destinationDimensionName = destination.method_27983().method_29177().toString();
                this.transitionHandler.handleEntityDimensionChange(newEntity, originDimensionName, destinationDimensionName);
            }
        });
    }
}

