/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.lostandfound;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFoundContext;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFoundScope;

public class LostAndFound {
    private static final String FILE_EXT = ".log";
    private static final DateTimeFormatter TIMESTAMP_FORMAT_TEXT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    private static final DateTimeFormatter TIMESTAMP_FORMAT_FILE = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH_mm_ss.SSSXX");
    private static final String BEGIN_METADATA = "--- BEGIN LOST+FOUND METADATA ---";
    private static final String END_METADATA = "--- END LOST+FOUND METADATA ---";
    private static final String BEGIN_CONTENT = "--- BEGIN LOST+FOUND CONTENT ---";
    private static final String END_CONTENT = "--- END LOST+FOUND CONTENT ---";
    private static final String BEGIN_EXCEPTION = "--- BEGIN LOST+FOUND EXCEPTION ---";
    private static final String END_EXCEPTION = "--- END LOST+FOUND EXCEPTION ---";
    private static final class_2561 DATA_LOSS_MESSAGE = class_2561.method_43470((String)"Some data was lost when crossing dimension pools. Consult server staff for more details and, possibly, data recovery.").method_27692(class_124.field_1061);
    public static LostAndFoundContext CONTEXT = LostAndFoundContext.create(new Object[0]);

    public static LostAndFoundContext init(Object ... scopes) {
        LostAndFoundContext context;
        CONTEXT = context = LostAndFoundContext.create(scopes);
        DimensionalInventories.LOGGER.debug(CONTEXT.toString());
        return context;
    }

    public static LostAndFoundScope push(Object ... layers) {
        LostAndFoundScope pushed = CONTEXT.push(layers);
        DimensionalInventories.LOGGER.debug(CONTEXT.toString());
        return pushed;
    }

    public static void log(String cause, String content) {
        LostAndFound.log(cause, content, null);
    }

    public static void log(String cause, String content, Exception exception) {
        LostAndFound.informPlayer();
        LocalDateTime now = LocalDateTime.now();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(BEGIN_METADATA);
        lines.add(now.format(TIMESTAMP_FORMAT_TEXT));
        lines.add(cause);
        lines.add(CONTEXT.toString());
        lines.add(END_METADATA);
        if (content != null) {
            lines.add("");
            lines.add(BEGIN_CONTENT);
            lines.add(content);
            lines.add(END_CONTENT);
        }
        if (exception != null) {
            lines.add("");
            lines.add(BEGIN_EXCEPTION);
            lines.add(exception.toString());
            lines.add(END_EXCEPTION);
        }
        String entry = String.join((CharSequence)"\n", lines);
        Path outputDirectory = CONTEXT.outputDirectory();
        Path outputFile = outputDirectory.resolve(now.format(TIMESTAMP_FORMAT_FILE) + FILE_EXT);
        DimensionalInventories.LOGGER.error(cause);
        DimensionalInventories.LOGGER.error("Context: {}", (Object)CONTEXT);
        try {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
            Files.writeString(outputFile, (CharSequence)entry, new OpenOption[0]);
            DimensionalInventories.LOGGER.error("Details have been written to lost+found");
            DimensionalInventories.LOGGER.error("File: '{}'", (Object)outputFile);
        }
        catch (IOException e) {
            DimensionalInventories.LOGGER.error("Failed to save lost+found entry:\n{}", (Object)entry);
            DimensionalInventories.LOGGER.error("Caused by:", (Throwable)e);
        }
    }

    private static void informPlayer() {
        try {
            CONTEXT.getPlayer().method_64398(DATA_LOSS_MESSAGE);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public static void log(String cause, Exception exception) {
        LostAndFound.log(cause, null, exception);
    }
}

