/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.minecraft.class_2487;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.module.base.ModuleState;
import net.thomilist.dimensionalinventories.module.base.StatefulModule;
import net.thomilist.dimensionalinventories.module.version.VersionedJsonData;
import net.thomilist.dimensionalinventories.module.version.VersionedJsonDataSerializerPair;
import net.thomilist.dimensionalinventories.util.gson.NbtCompoundSerializerPair;
import net.thomilist.dimensionalinventories.util.gson.OptionalSerializerPair;

public interface JsonModule<T extends ModuleState>
extends StatefulModule<T> {
    public static final GsonBuilder GSON_BUILDER = new GsonBuilder().registerTypeAdapter(VersionedJsonData.class, (Object)new VersionedJsonDataSerializerPair()).registerTypeAdapter(Optional.class, new OptionalSerializerPair()).registerTypeAdapter(class_2487.class, (Object)new NbtCompoundSerializerPair()).setPrettyPrinting();

    public Gson gson();

    default public String noSuchFileWarning() {
        return "No data found (default data loaded instead)";
    }

    default public String saveFileName() {
        return this.moduleId() + ".json";
    }

    default public T load(Path saveFile) {
        T data;
        String json;
        try {
            json = Files.readString(saveFile);
        }
        catch (NoSuchFileException e) {
            DimensionalInventories.LOGGER.warn(this.noSuchFileWarning());
            DimensionalInventories.LOGGER.warn("Context: {}", (Object)LostAndFound.CONTEXT);
            return this.defaultState();
        }
        catch (IOException e) {
            LostAndFound.log("Failed to load data", saveFile.toString(), e);
            return this.state();
        }
        try {
            data = this.loadFromJsonString(json);
        }
        catch (JsonParseException e) {
            LostAndFound.log("Failed to parse JSON data", json, (Exception)((Object)e));
            return this.state();
        }
        return data;
    }

    default public T loadFromJsonString(String json) throws JsonParseException {
        VersionedJsonData versionedData = (VersionedJsonData)this.gson().fromJson(json, VersionedJsonData.class);
        return this.loadVersionedData(versionedData);
    }

    default public T loadVersionedData(VersionedJsonData versionedData) throws JsonParseException {
        return this.loadAsCurrentVersion(versionedData.data());
    }

    default public T loadAsCurrentVersion(JsonElement data) throws JsonParseException {
        return (T)((ModuleState)this.gson().fromJson(data, this.state().type()));
    }

    default public void save(Path saveFile, T data) {
        JsonElement dataJson = this.gson().toJsonTree(data);
        VersionedJsonData versionedData = new VersionedJsonData(this.moduleVersion(), dataJson);
        String json = this.gson().toJson((Object)versionedData);
        try {
            Files.createDirectories(saveFile.getParent(), new FileAttribute[0]);
            Files.writeString(saveFile, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            LostAndFound.log("Unable to save data", json, e);
        }
    }
}

