/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.base;

import java.util.SortedSet;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFoundFormattable;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;
import net.thomilist.dimensionalinventories.util.StringHelper;
import org.jetbrains.annotations.NotNull;

public interface Module
extends Comparable<Module>,
LostAndFoundFormattable {
    public String category();

    public String description();

    public SortedSet<StorageVersion> storageVersions();

    public String groupId();

    public String moduleId();

    default public int moduleVersion() {
        return 1;
    }

    default public StorageVersion latestStorageVersion() {
        return this.storageVersions().last();
    }

    default public void registerCommands() {
    }

    default public String toFormatted() {
        return "%s module %s".formatted(this.category(), StringHelper.joinAndWrapScopes(this.groupId(), "%s (%s)".formatted(this.moduleId(), this.toString())));
    }

    @Override
    default public int compareTo(@NotNull Module other) {
        if (!this.groupId().equals(other.groupId())) {
            return this.groupId().compareTo(other.groupId());
        }
        if (!this.moduleId().equals(other.moduleId())) {
            return this.moduleId().compareTo(other.moduleId());
        }
        return StorageVersion.compareSets(this.storageVersions(), other.storageVersions());
    }

    @Override
    default public String toLostAndFoundScopeString() {
        return StringHelper.joinScopes(this.groupId(), this.moduleId());
    }
}

