/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.builtin.inventory;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFoundScope;
import net.thomilist.dimensionalinventories.module.builtin.inventory.InventoryModuleState;
import net.thomilist.dimensionalinventories.module.builtin.inventory.InventorySection;
import net.thomilist.dimensionalinventories.module.builtin.inventory.ItemStackListSerializerPair;
import net.thomilist.dimensionalinventories.util.ItemStackListHelper;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

public class InventoryModuleStateSerializerPair
implements SerializerPair<InventoryModuleState> {
    @Override
    public InventoryModuleState fromJson(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            LostAndFound.log("Unexpected JSON structure for inventory data (expected an object)", json.toString());
            return new InventoryModuleState();
        }
        InventoryModuleState inventoryModuleState = new InventoryModuleState();
        JsonObject inventoryJson = json.getAsJsonObject();
        for (InventorySection label : InventorySection.list()) {
            LostAndFoundScope LAF = LostAndFound.push(new Object[]{label});
            try {
                JsonElement stacksJson = inventoryJson.get(label.toString());
                class_2371 items = (class_2371)context.deserialize(stacksJson, ItemStackListSerializerPair.TYPE);
                if (items.isEmpty()) continue;
                ItemStackListHelper.assignItemStacks((class_2371<class_1799>)items, inventoryModuleState.section(label));
            }
            finally {
                if (LAF == null) continue;
                LAF.close();
            }
        }
        return inventoryModuleState;
    }

    @Override
    public JsonElement toJson(InventoryModuleState src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        for (InventorySection label : InventorySection.list()) {
            LostAndFoundScope LAF = LostAndFound.push(new Object[]{label});
            try {
                json.add(label.toString(), context.serialize(src.section(label), ItemStackListSerializerPair.TYPE));
            }
            finally {
                if (LAF == null) continue;
                LAF.close();
            }
        }
        return json;
    }
}

