/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.builtin.inventory;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

public class ItemStackListSerializerPair
implements SerializerPair<class_2371<class_1799>> {
    public static final Type TYPE = new ItemStackListSerializerPair().type();

    @Override
    public class_2371<class_1799> fromJson(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonArray()) {
            LostAndFound.log("Unexpected JSON structure for list of item stacks (expected an array)", json.getAsString());
            return class_2371.method_37434((int)0);
        }
        JsonArray jsonArray = json.getAsJsonArray();
        class_2371 items = class_2371.method_10213((int)jsonArray.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < jsonArray.size(); ++i) {
            items.set(i, (Object)Objects.requireNonNullElse((class_1799)context.deserialize(jsonArray.get(i), class_1799.class), class_1799.field_8037));
        }
        return items;
    }

    @Override
    public JsonElement toJson(class_2371<class_1799> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray json = new JsonArray();
        for (class_1799 itemStack : src) {
            json.add(context.serialize((Object)itemStack, class_1799.class));
        }
        return json;
    }
}

