/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.builtin.pool;

import java.util.List;
import java.util.TreeSet;
import net.minecraft.class_1934;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFoundFormattable;
import net.thomilist.dimensionalinventories.module.builtin.legacy.pool.DimensionPool_SV1;

public final class DimensionPool
implements LostAndFoundFormattable {
    private static final List<String> DEFAULT_DIMENSIONS = List.of("minecraft:overworld", "minecraft:the_nether", "minecraft:the_end");
    private static final String DEFAULT_DIMENSION_POOL_ID = "default";
    private final TreeSet<String> dimensions = new TreeSet();
    private String id;
    private String displayName;
    private class_1934 gameMode = class_1934.field_28045;
    private boolean progressAdvancements = true;
    private boolean incrementStatistics = true;

    private DimensionPool() {
    }

    public DimensionPool(String id) {
        this.setId(id);
        this.setDisplayName(id);
    }

    public DimensionPool(String id, class_1934 gameMode) {
        this(id);
        this.setGameMode(gameMode);
    }

    public static DimensionPool createDefault() {
        DimensionPool dimensionPool = new DimensionPool(DEFAULT_DIMENSION_POOL_ID);
        for (String dimension : DEFAULT_DIMENSIONS) {
            dimensionPool.addDimension(dimension);
        }
        return dimensionPool;
    }

    public static DimensionPool fromLegacy(DimensionPool_SV1 legacyDimensionPool) {
        DimensionPool newDimensionPool = new DimensionPool();
        newDimensionPool.setId(legacyDimensionPool.name());
        newDimensionPool.setDisplayName(legacyDimensionPool.name());
        newDimensionPool.setGameMode(legacyDimensionPool.gameMode());
        newDimensionPool.setProgressAdvancements(legacyDimensionPool.progressAdvancements());
        newDimensionPool.setIncrementStatistics(legacyDimensionPool.incrementStatistics());
        for (String dimension : legacyDimensionPool.dimensions()) {
            newDimensionPool.addDimension(dimension);
        }
        return newDimensionPool;
    }

    public String getId() {
        return this.id;
    }

    private void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void addDimension(String dimension) {
        this.dimensions.add(dimension);
    }

    public void removeDimension(String dimension) {
        this.dimensions.remove(dimension);
    }

    public TreeSet<String> getDimensions() {
        return this.dimensions;
    }

    public boolean hasDimensions(String ... dimensions) {
        for (String dimension : dimensions) {
            if (this.dimensions.contains(dimension)) continue;
            return false;
        }
        return true;
    }

    public class_1934 getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(class_1934 gameMode) {
        this.gameMode = gameMode;
    }

    public void setProgressAdvancements(boolean setting) {
        this.progressAdvancements = setting;
    }

    public boolean canProgressAdvancements() {
        return this.progressAdvancements;
    }

    public void setIncrementStatistics(boolean setting) {
        this.incrementStatistics = setting;
    }

    public boolean canIncrementStatistics() {
        return this.incrementStatistics;
    }

    public String asString() {
        StringBuilder dimensionPoolString = new StringBuilder();
        dimensionPoolString.append("\n[").append(this.getId()).append(']');
        dimensionPoolString.append("\n    Rules:");
        dimensionPoolString.append("\n        Gamemode: ").append(this.getGameMode().method_15434());
        dimensionPoolString.append("\n        Progress advancements: ").append(this.canProgressAdvancements());
        dimensionPoolString.append("\n        Increment statistics: ").append(this.canIncrementStatistics());
        dimensionPoolString.append("\n    Dimensions:");
        for (String dimension : this.getDimensions()) {
            dimensionPoolString.append("\n        ").append(dimension);
        }
        return dimensionPoolString.toString();
    }

    @Override
    public String toLostAndFoundScopeString() {
        return this.getDisplayName() + " (" + this.getId() + ")";
    }
}

