/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.builtin.pool;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

public class DimensionPoolMapSerializerPair
implements SerializerPair<HashMap<String, DimensionPool>> {
    public static final Type TYPE = new DimensionPoolMapSerializerPair().type();

    @Override
    public HashMap<String, DimensionPool> fromJson(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonArray()) {
            LostAndFound.log("Unexpected JSON structure for dimension pool config (expected an array)", json.getAsString());
            return new HashMap<String, DimensionPool>();
        }
        HashMap<String, DimensionPool> dimensionPools = new HashMap<String, DimensionPool>();
        JsonArray dimensionPoolsJson = json.getAsJsonArray();
        for (JsonElement entry : dimensionPoolsJson) {
            DimensionPool dimensionPool = (DimensionPool)context.deserialize(entry, DimensionPool.class);
            dimensionPools.put(dimensionPool.getId(), dimensionPool);
        }
        return dimensionPools;
    }

    @Override
    public JsonElement toJson(HashMap<String, DimensionPool> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray json = new JsonArray();
        for (Map.Entry<String, DimensionPool> entry : src.entrySet()) {
            json.add(context.serialize((Object)entry.getValue(), DimensionPool.class));
        }
        return json;
    }
}

