/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.builtin.pool;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3829;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.module.ModuleRegistry;
import net.thomilist.dimensionalinventories.module.base.config.ConfigModule;
import net.thomilist.dimensionalinventories.module.base.player.PlayerModule;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolConfigModule;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;

public class DimensionPoolTransitionHandler {
    private final StorageVersion storageVersion;
    private final ModuleRegistry<ConfigModule> configModules;
    private final ModuleRegistry<PlayerModule> playerModules;
    private final Map<class_1297, TransitionInfo> lastTransitions = new HashMap<class_1297, TransitionInfo>();

    public DimensionPoolTransitionHandler(StorageVersion storageVersion, ModuleRegistry<ConfigModule> configModules, ModuleRegistry<PlayerModule> playerModules) {
        this.storageVersion = storageVersion;
        this.configModules = configModules;
        this.playerModules = playerModules;
    }

    public void loadToPlayer(StorageVersion storageVersion, DimensionPool dimensionPool, class_3222 player) {
        if (this.playerModules.has(storageVersion)) {
            for (PlayerModule module : this.playerModules.get(storageVersion)) {
                module.loadWithContext(player, dimensionPool);
            }
        }
    }

    public void saveFromPlayer(StorageVersion storageVersion, DimensionPool dimensionPool, class_3222 player) {
        if (this.playerModules.has(storageVersion)) {
            for (PlayerModule module : this.playerModules.get(storageVersion)) {
                module.saveWithContext(player, dimensionPool);
            }
        }
    }

    public void handlePlayerDimensionChange(class_3222 player, String originDimensionName, String destinationDimensionName) {
        if (this.transitionAlreadyHandled((class_1297)player, originDimensionName, destinationDimensionName).booleanValue()) {
            return;
        }
        DimensionalInventories.LOGGER.debug("Player '{}' ({}) travelled from {} to {}.", new Object[]{player.method_5477().getString(), player.method_5845(), originDimensionName, destinationDimensionName});
        DimensionPoolConfigModule dimensionPoolConfig = this.configModules.get(DimensionPoolConfigModule.class);
        if (dimensionPoolConfig.state().dimensionsAreInSamePool(originDimensionName, destinationDimensionName)) {
            DimensionalInventories.LOGGER.debug("The origin and destination dimensions are in the same pool. Player unaffected.");
        } else {
            DimensionalInventories.LOGGER.debug("The origin and destination dimensions are in different pools. Switching inventories...");
            Optional<DimensionPool> originDimensionPool = dimensionPoolConfig.state().poolWithDimension(originDimensionName);
            Optional<DimensionPool> destinationDimensionPool = dimensionPoolConfig.state().poolWithDimension(destinationDimensionName);
            if (originDimensionPool.isEmpty() || destinationDimensionPool.isEmpty()) {
                DimensionalInventories.LOGGER.warn("Not all dimensions are assigned to a dimension pool. Player '{}' unaffected ({} -> {}).", new Object[]{player.method_5477().getString(), originDimensionName, destinationDimensionName});
                return;
            }
            this.saveFromPlayer(this.storageVersion, originDimensionPool.get(), player);
            this.loadToPlayer(this.storageVersion, destinationDimensionPool.get(), player);
        }
    }

    public void handleEntityDimensionChange(class_1297 newEntity, String originDimensionName, String destinationDimensionName) {
        if (this.transitionAlreadyHandled(newEntity, originDimensionName, destinationDimensionName).booleanValue()) {
            return;
        }
        DimensionPoolConfigModule dimensionPoolConfig = this.configModules.get(DimensionPoolConfigModule.class);
        if (!dimensionPoolConfig.state().dimensionsAreInSamePool(originDimensionName, destinationDimensionName)) {
            DimensionalInventories.LOGGER.debug("Entity '{}' travelled from {} to {}.", new Object[]{newEntity.method_5477().getString(), originDimensionName, destinationDimensionName});
            DimensionalInventories.LOGGER.debug("The origin and destination dimensions are in different pools. Deleting entity...");
            Optional<DimensionPool> originDimension = dimensionPoolConfig.state().poolWithDimension(originDimensionName);
            Optional<DimensionPool> destinationDimension = dimensionPoolConfig.state().poolWithDimension(destinationDimensionName);
            if (originDimension.isEmpty() || destinationDimension.isEmpty()) {
                DimensionalInventories.LOGGER.warn("Not all dimensions are assigned a dimension pool. Entity '{}' unaffected ({} -> {}).", new Object[]{newEntity.method_5477().getString(), originDimensionName, destinationDimensionName});
                return;
            }
            if (newEntity instanceof class_3829) {
                ((class_3829)newEntity).method_5448();
            }
            newEntity.method_31472();
        }
    }

    private Boolean transitionAlreadyHandled(class_1297 newEntity, String originDimensionName, String destinationDimensionName) {
        TransitionInfo oldTransitionInfo = this.lastTransitions.get(newEntity);
        TransitionInfo newTransitionInfo = new TransitionInfo(originDimensionName, destinationDimensionName);
        if (oldTransitionInfo != null && oldTransitionInfo.equals(newTransitionInfo)) {
            DimensionalInventories.LOGGER.debug("Transition already handled. Entity '{}' unaffected ({} -> {}).", new Object[]{newEntity.method_5477().getString(), originDimensionName, destinationDimensionName});
            return true;
        }
        this.lastTransitions.put(newEntity, newTransitionInfo);
        return false;
    }

    record TransitionInfo(String originDimensionName, String destinationDimensionName) {
    }
}

