/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.version;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.class_1934;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.exception.ModuleNotRegisteredException;
import net.thomilist.dimensionalinventories.exception.StorageVersionMigrationException;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFoundScope;
import net.thomilist.dimensionalinventories.module.ModuleRegistry;
import net.thomilist.dimensionalinventories.module.base.config.ConfigModule;
import net.thomilist.dimensionalinventories.module.builtin.legacy.pool.DimensionPoolConfigModule_SV1;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolConfigModule;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolConfigModuleState;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolTransitionHandler;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;
import net.thomilist.dimensionalinventories.util.DummyServerPlayerEntity;
import net.thomilist.dimensionalinventories.util.SavePaths;
import org.apache.commons.io.FileUtils;

public class StorageVersionMigration {
    private static final String LEGACY_BASE_SAVE_DIRECTORY_NAME = "dimensionalinventories";
    private final StorageVersion targetStorageVersion;
    private final ModuleRegistry<ConfigModule> configModules;
    private final DimensionPoolTransitionHandler transitionHandler;
    private final String legacyBaseSaveDirectoryName;
    private Path legacyBaseSaveDirectory;

    public StorageVersionMigration(StorageVersion targetStorageVersion, ModuleRegistry<ConfigModule> configModules, DimensionPoolTransitionHandler transitionHandler, String legacyBaseSaveDirectoryName) {
        this.targetStorageVersion = targetStorageVersion;
        this.configModules = configModules;
        this.transitionHandler = transitionHandler;
        this.legacyBaseSaveDirectoryName = legacyBaseSaveDirectoryName;
    }

    public StorageVersionMigration(StorageVersion targetStorageVersion, ModuleRegistry<ConfigModule> configModules, DimensionPoolTransitionHandler transitionHandler) {
        this(targetStorageVersion, configModules, transitionHandler, LEGACY_BASE_SAVE_DIRECTORY_NAME);
    }

    public void tryMigrate(MinecraftServer server) {
        try (LostAndFoundScope LAF = LostAndFound.push("storage version migration");){
            this.legacyBaseSaveDirectory = server.method_27050(class_5218.field_24188).resolve(this.legacyBaseSaveDirectoryName);
            StorageVersion writtenStorageVersion = this.determineWrittenDataVersion();
            if (writtenStorageVersion == null) {
                DimensionalInventories.LOGGER.info("No data found");
                DimensionalInventories.LOGGER.info("Initialising with storage version {}...", (Object)this.targetStorageVersion.version);
            } else if (writtenStorageVersion != this.targetStorageVersion) {
                DimensionalInventories.LOGGER.info("Data from storage version {} found.", (Object)writtenStorageVersion.version);
                DimensionalInventories.LOGGER.info("Migrating to storage version {}...", (Object)this.targetStorageVersion.version);
                this.migrate(writtenStorageVersion, this.targetStorageVersion, server);
                DimensionalInventories.LOGGER.info("Migration complete");
            } else {
                DimensionalInventories.LOGGER.info("Data from storage version {} found (up to date)", (Object)writtenStorageVersion.version);
            }
        }
    }

    public StorageVersion determineWrittenDataVersion() {
        for (StorageVersion storageVersion : StorageVersion.reversed()) {
            if (!Files.exists(SavePaths.saveDirectory(storageVersion), new LinkOption[0])) continue;
            return storageVersion;
        }
        if (Files.exists(this.legacyBaseSaveDirectory, new LinkOption[0])) {
            return StorageVersion.V1;
        }
        return null;
    }

    private void migrate(StorageVersion from, StorageVersion to, MinecraftServer server) throws StorageVersionMigrationException {
        block12: {
            try (LostAndFoundScope LAF = LostAndFound.push("migrate %s..%s".formatted(new Object[]{from, to}));){
                if (from.version > StorageVersion.V1.version || to.version < StorageVersion.V2.version) break block12;
                try (LostAndFoundScope LAF_1_2 = LostAndFound.push(String.valueOf((Object)StorageVersion.V1) + ".." + String.valueOf((Object)StorageVersion.V2));){
                    this.migrate1to2(server);
                }
            }
        }
    }

    private void migrate1to2(MinecraftServer server) throws StorageVersionMigrationException {
        DimensionalInventories.LOGGER.info("Preparing migration step from {} to {}...", (Object)StorageVersion.V1, (Object)StorageVersion.V2);
        this.prepareMigration1to2();
        this.migrateConfig1to2();
        this.migratePlayers1to2(server);
        DimensionalInventories.LOGGER.info("Migration step from {} to {} complete", (Object)StorageVersion.V1, (Object)StorageVersion.V2);
    }

    private void prepareMigration1to2() throws StorageVersionMigrationException {
        try (LostAndFoundScope LAF = LostAndFound.push("prepare");){
            DimensionalInventories.LOGGER.info("Copying {} data...", (Object)StorageVersion.V1);
            try {
                FileUtils.copyDirectory((File)this.legacyBaseSaveDirectory.toFile(), (File)SavePaths.saveDirectory(StorageVersion.V1).toFile());
            }
            catch (IOException e) {
                throw new StorageVersionMigrationException(StorageVersion.V1, StorageVersion.V2, "Unable to copy %s data".formatted(new Object[]{StorageVersion.V1}), e);
            }
            DimensionalInventories.LOGGER.info("Creating {} directory...", (Object)StorageVersion.V2);
            try {
                Files.createDirectories(SavePaths.saveDirectory(StorageVersion.V2), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new StorageVersionMigrationException(StorageVersion.V1, StorageVersion.V2, "Unable to create %s directory".formatted(new Object[]{StorageVersion.V2}), e);
            }
        }
    }

    private void migrateConfig1to2() {
        try (LostAndFoundScope LAF = LostAndFound.push("config");){
            DimensionPoolConfigModule newConfigModule;
            DimensionPoolConfigModule_SV1 legacyConfigModule;
            DimensionalInventories.LOGGER.info("Migrating config to {}...", (Object)StorageVersion.V2);
            try {
                legacyConfigModule = this.configModules.get(DimensionPoolConfigModule_SV1.class);
                newConfigModule = this.configModules.get(DimensionPoolConfigModule.class);
            }
            catch (ModuleNotRegisteredException e) {
                throw new StorageVersionMigrationException(StorageVersion.V1, StorageVersion.V2, "Failed to migrate dimension pool config", e);
            }
            legacyConfigModule.loadWithContext();
            DimensionPoolConfigModuleState newConfigData = DimensionPoolConfigModuleState.fromLegacy(legacyConfigModule.state());
            newConfigModule.loadFromOther(newConfigData);
            newConfigModule.saveWithContext();
        }
    }

    private void migratePlayers1to2(MinecraftServer server) {
        try (LostAndFoundScope LAF = LostAndFound.push("players");){
            DimensionalInventories.LOGGER.info("Migrating player data to {}...", (Object)StorageVersion.V2);
            File[] v1DimensionPoolDirectories = SavePaths.saveDirectory(StorageVersion.V1).toFile().listFiles(File::isDirectory);
            if (v1DimensionPoolDirectories == null) {
                DimensionalInventories.LOGGER.warn("Migration step from {} to {} finished early: No player data found", (Object)StorageVersion.V1, (Object)StorageVersion.V2);
                return;
            }
            for (File v1DimensionPoolDirectory : v1DimensionPoolDirectories) {
                File[] files = v1DimensionPoolDirectory.listFiles(File::isFile);
                if (files == null) continue;
                String dimensionPoolName = v1DimensionPoolDirectory.getName();
                DimensionalInventories.LOGGER.info("Migrating dimension pool '{}'...", (Object)dimensionPoolName);
                DimensionPool tempDimensionPool = new DimensionPool(dimensionPoolName, class_1934.field_28045);
                for (File v1InventoryFile : files) {
                    String uuid = v1InventoryFile.getName().replace(".txt", "");
                    DimensionalInventories.LOGGER.debug("Migrating data for player '{}' (UUID)...", (Object)uuid);
                    DummyServerPlayerEntity dummyPlayer = new DummyServerPlayerEntity(server, uuid);
                    this.transitionHandler.loadToPlayer(StorageVersion.V1, tempDimensionPool, dummyPlayer);
                    this.transitionHandler.saveFromPlayer(StorageVersion.V2, tempDimensionPool, dummyPlayer);
                }
            }
        }
    }
}

