/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module.version;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.module.version.VersionedJsonData;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

public class VersionedJsonDataSerializerPair
implements SerializerPair<VersionedJsonData> {
    private static final String VERSION_FIELD = "version";
    private static final String DATA_FIELD = "data";

    private static void logMissingField(String field, JsonElement json) {
        LostAndFound.log("Missing field '%s' in versioned data JSON".formatted(field), json.toString());
    }

    @Override
    public VersionedJsonData fromJson(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject() && !json.isJsonObject()) {
            LostAndFound.log("Unexpected JSON structure for versioned data (expected an object)", json.toString());
            return null;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        if (!jsonObject.has(VERSION_FIELD)) {
            VersionedJsonDataSerializerPair.logMissingField(VERSION_FIELD, json);
            return null;
        }
        JsonElement versionJson = jsonObject.get(VERSION_FIELD);
        if (!versionJson.isJsonPrimitive()) {
            LostAndFound.log("Unexpected JSON structure for field '%s' (expected an integer)".formatted(VERSION_FIELD), json.toString());
            return null;
        }
        int version = versionJson.getAsInt();
        if (!jsonObject.has(DATA_FIELD)) {
            VersionedJsonDataSerializerPair.logMissingField(DATA_FIELD, json);
            return null;
        }
        JsonElement dataJson = jsonObject.get(DATA_FIELD);
        return new VersionedJsonData(version, dataJson);
    }

    @Override
    public JsonElement toJson(VersionedJsonData src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.add(VERSION_FIELD, context.serialize((Object)src.version()));
        json.add(DATA_FIELD, context.serialize((Object)src.data()));
        return json;
    }
}

