/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.util.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.util.gson.SerializerPair;

public class NbtCompoundSerializerPair
implements SerializerPair<class_2487> {
    @Override
    public class_2487 fromJson(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonPrimitive()) {
            LostAndFound.log("Unexpected JSON structure for NBT compound (expected a string)", json.toString());
            return null;
        }
        String nbtString = json.getAsJsonPrimitive().getAsString();
        try {
            return class_2512.method_32260((String)nbtString);
        }
        catch (CommandSyntaxException e) {
            LostAndFound.log("Invalid NBT string", nbtString, (Exception)((Object)e));
            return null;
        }
    }

    @Override
    public JsonElement toJson(class_2487 src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return null;
        }
        return new JsonPrimitive(class_2512.method_32271((class_2487)src));
    }
}

