/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.util.gson;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFound;
import net.thomilist.dimensionalinventories.lostandfound.LostAndFoundScope;

public interface SerializerPair<T>
extends JsonSerializer<T>,
JsonDeserializer<T> {
    public T fromJson(JsonElement var1, Type var2, JsonDeserializationContext var3) throws JsonParseException;

    public JsonElement toJson(T var1, Type var2, JsonSerializationContext var3);

    default public Type type() {
        return new TypeToken<T>(this.getClass()){}.getType();
    }

    default public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        try (LostAndFoundScope LAF = LostAndFound.push("deserialize (" + typeOfT.getTypeName() + ")");){
            T t = this.fromJson(json, typeOfT, context);
            return t;
        }
    }

    default public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        try (LostAndFoundScope LAF = LostAndFound.push("serialize (" + typeOfSrc.getTypeName() + ")");){
            JsonElement jsonElement = this.toJson(src, typeOfSrc, context);
            return jsonElement;
        }
    }
}

