package net.thomilist.dimensionalinventories.compatibility.minecraft.nbt;

import net.minecraft.class_11362;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import net.thomilist.dimensionalinventories.compatibility.LimitedCompatibility;

import java.util.Optional;

@LimitedCompatibility( target = "Minecraft",
                       versions = ">=1.21.6" )
public final class NbtCompatWrapper_Minecraft_1_21_6
    implements NbtCompatWrapper
{
    private class_7225.class_7874 wrapperLookup;

    @Override
    public void onServerStarted( final MinecraftServer server )
    {
        NbtCompatWrapper.super.onServerStarted( server );
        this.wrapperLookup = server.method_30611();
    }

    @Override
    public class_1799 toItemStack( final class_2487 nbtCompound )
    {
        if ( nbtCompound.method_33133() )
        {
            return class_1799.field_8037;
        }

        final Optional<String> id = nbtCompound.method_10558( "id" );

        if ( id.isEmpty() )
        {
            return class_1799.field_8037;
        }

        if ( id.get().matches( "^minecraft:air$" ) )
        {
            return class_1799.field_8037;
        }

        return class_1799.field_24671
            .parse( this.wrapperLookup.method_57093( class_2509.field_11560 ), nbtCompound )
            .result()
            .orElse( null );
    }

    @Override
    public class_2487 fromItemStack( final class_1799 itemStack )
    {
        if ( itemStack.method_7960() )
        {
            return null;
        }

        return (class_2487) class_1799.field_24671
            .encodeStart( this.wrapperLookup.method_57093( class_2509.field_11560 ), itemStack )
            .getOrThrow();
    }

    @Override
    public class_1293 toStatusEffectInstance( final class_2487 nbtCompound )
    {
        return class_1293.field_48821.parse( class_2509.field_11560, nbtCompound ).result().orElse( null );
    }

    @Override
    public class_2487 fromStatusEffectInstance( final class_1293 statusEffectInstance )
    {
        return (class_2487) class_1293.field_48821
            .encodeStart( class_2509.field_11560, statusEffectInstance )
            .result()
            .orElse( new class_2487() );
    }

    @Override
    public class_2487 fromEntity( final class_1297 entity )
    {
        final class_11362 nbtWriteView = class_11362.method_71459( new class_8942.class_8943(), this.wrapperLookup );
        entity.method_5647( nbtWriteView );
        return nbtWriteView.method_71475();
    }
}
