package net.thomilist.dimensionalinventories.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.compatibility.Compat;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolConfigModule;
import net.thomilist.dimensionalinventories.util.LogThrottler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;

@Mixin( class_1657.class )
public abstract class DisableStatisticIncrementMixin
    extends class_1309
{
    @Unique
    private static final LogThrottler LOG_THROTTLER = new LogThrottler( 10000 );

    @Unique
    private static DimensionPoolConfigModule DIMENSION_POOL_CONFIG;

    protected DisableStatisticIncrementMixin( final class_1937 world,
                                              final class_2338 pos,
                                              final float yaw,
                                              final GameProfile gameProfile )
    {
        super( class_1299.field_6097, world );
    }

    @Unique
    private static DimensionPoolConfigModule dimensionPoolConfig()
    {
        if ( DisableStatisticIncrementMixin.DIMENSION_POOL_CONFIG == null )
        {
            DisableStatisticIncrementMixin.DIMENSION_POOL_CONFIG = DimensionalInventories.INSTANCE.configModules.get(
                DimensionPoolConfigModule.class );
        }

        return DisableStatisticIncrementMixin.DIMENSION_POOL_CONFIG;
    }

    @Inject( at = @At( "HEAD" ),
             method = "incrementStat(Lnet/minecraft/util/Identifier;)V",
             cancellable = true )
    public void incrementStat( final class_2960 stat, final CallbackInfo info )
    {
        if ( !this.canPoolIncrementStatistics() )
        {
            info.cancel();
        }
    }

    @Unique
    public boolean canPoolIncrementStatistics()
    {
        final String dimensionName = Compat.ENTITY.getWorld( this ).method_27983().method_29177().toString();

        final Optional<DimensionPool> pool = DisableStatisticIncrementMixin
            .dimensionPoolConfig()
            .state()
            .poolWithDimension( dimensionName, DisableStatisticIncrementMixin.LOG_THROTTLER.get() );

        return pool.map( DimensionPool::canIncrementStatistics ).orElse( true );
    }

    @Inject( at = @At( "HEAD" ),
             method = "increaseStat(Lnet/minecraft/util/Identifier;I)V",
             cancellable = true )
    public void increaseStat( final class_2960 stat, final int amount, final CallbackInfo info )
    {
        if ( !this.canPoolIncrementStatistics() )
        {
            info.cancel();
        }
    }

    @Inject( at = @At( "HEAD" ),
             method = "incrementStat(Lnet/minecraft/stat/Stat;)V",
             cancellable = true )
    public void incrementStat( final class_3445<?> stat, final CallbackInfo info )
    {
        if ( !this.canPoolIncrementStatistics() )
        {
            info.cancel();
        }
    }

    @Inject( at = @At( "HEAD" ),
             method = "increaseStat(Lnet/minecraft/stat/Stat;I)V",
             cancellable = true )
    public void increaseStat( final class_3445<?> stat, final int amount, final CallbackInfo info )
    {
        if ( !this.canPoolIncrementStatistics() )
        {
            info.cancel();
        }
    }
}
