package net.thomilist.dimensionalinventories.module.base;

import net.thomilist.dimensionalinventories.exception.ModuleConstructionException;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;

import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class ModuleBase
    implements Module
{
    private final String groupId;
    private final String moduleId;
    private final String description;
    private final SortedSet<StorageVersion> storageVersions = new TreeSet<>();

    protected ModuleBase( final StorageVersion[] storageVersions,
                          final String groupId,
                          final String moduleId,
                          final String description )
    {
        this.groupId = groupId;
        this.moduleId = moduleId;
        this.description = description;
        this.storageVersions.addAll( List.of( storageVersions ) );
    }

    public static <T extends Module> T createDerived( final Class<T> moduleType, final String groupId )
        throws ModuleConstructionException
    {
        try
        {
            return moduleType.getConstructor( String.class ).newInstance( groupId );
        }
        catch ( final Exception e )
        {
            throw new ModuleConstructionException( moduleType, groupId, e );
        }
    }

    @Override
    public String description()
    {
        return this.description;
    }

    @Override
    public SortedSet<StorageVersion> storageVersions()
    {
        return this.storageVersions;
    }

    @Override
    public String groupId()
    {
        return this.groupId;
    }

    @Override
    public String moduleId()
    {
        return this.moduleId;
    }
}
