package net.thomilist.dimensionalinventories.module.base.player;

import net.minecraft.class_3222;
import net.thomilist.dimensionalinventories.module.base.StatefulModule;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.util.SavePaths;

import java.nio.file.Path;

public interface StatefulPlayerModule<T extends PlayerModuleState>
    extends PlayerModule, StatefulModule<T>
{
    T newInstance( class_3222 player );

    default Path saveDirectory( final class_3222 player, final DimensionPool dimensionPool )
    {
        return SavePaths.saveDirectory( this.latestStorageVersion(), dimensionPool, player, this.groupId() );
    }
}
