package net.thomilist.dimensionalinventories.module.builtin.inventory;

import net.minecraft.class_1661;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.thomilist.dimensionalinventories.compatibility.Compat;
import net.thomilist.dimensionalinventories.module.base.player.PlayerModuleState;
import net.thomilist.dimensionalinventories.util.ItemStackListHelper;

import java.lang.reflect.Type;

public class InventoryModuleState
    implements PlayerModuleState
{
    private static final int ARMOR_SIZE = 4;
    private static final int MAIN_SIZE = class_1661.field_30638;
    private static final int OFF_HAND_SIZE = 1;
    private static final int ENDER_CHEST_SIZE = new class_1730().method_5439();

    public final class_2371<class_1799> armor = class_2371.method_10213(
        InventoryModuleState.ARMOR_SIZE,
        class_1799.field_8037
    );
    public final class_2371<class_1799> main = class_2371.method_10213(
        InventoryModuleState.MAIN_SIZE,
        class_1799.field_8037
    );
    public final class_2371<class_1799> offHand = class_2371.method_10213(
        InventoryModuleState.OFF_HAND_SIZE,
        class_1799.field_8037
    );
    public final class_2371<class_1799> enderChest = class_2371.method_10213(
        InventoryModuleState.ENDER_CHEST_SIZE,
        class_1799.field_8037
    );

    public InventoryModuleState()
    { }

    public InventoryModuleState( final class_3222 player )
    {
        this.loadFromPlayer( player );
    }

    @Override
    public Type type()
    {
        return InventoryModuleState.class;
    }

    @Override
    public void applyToPlayer( final class_3222 player )
    {
        Compat.PLAYER_INVENTORY.setArmor( player.method_31548(), this.armor );
        Compat.PLAYER_INVENTORY.setMain( player.method_31548(), this.main );
        Compat.PLAYER_INVENTORY.setOffHand( player.method_31548(), this.offHand );
        Compat.SIMPLE_INVENTORY.setHeldStacks( player.method_7274(), this.enderChest );
    }

    @Override
    public void loadFromPlayer( final class_3222 player )
    {
        ItemStackListHelper.assignItemStacks( Compat.PLAYER_INVENTORY.getArmor( player.method_31548() ), this.armor );
        ItemStackListHelper.assignItemStacks( Compat.PLAYER_INVENTORY.getMain( player.method_31548() ), this.main );
        ItemStackListHelper.assignItemStacks(
            Compat.PLAYER_INVENTORY.getOffHand( player.method_31548() ),
            this.offHand
        );
        ItemStackListHelper.assignItemStacks(
            Compat.SIMPLE_INVENTORY.getHeldStacks( player.method_7274() ),
            this.enderChest
        );
    }

    public class_2371<class_1799> section( final InventorySection label )
    {
        return switch ( label )
        {
            case ARMOR -> this.armor;
            case MAIN -> this.main;
            case OFF_HAND -> this.offHand;
            case ENDER_CHEST -> this.enderChest;
        };
    }
}
