package net.thomilist.dimensionalinventories.module.builtin.shoulderentity;

import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.thomilist.dimensionalinventories.mixin.ServerPlayerEntityAccessor;
import net.thomilist.dimensionalinventories.module.base.player.PlayerModuleState;

import java.lang.reflect.Type;

public class ShoulderEntityModuleState
    implements PlayerModuleState
{
    public class_2487 leftShoulderEntity = new class_2487();
    public class_2487 rightShoulderEntity = new class_2487();
    public long shoulderEntityAddedTime = 0;

    public ShoulderEntityModuleState()
    { }

    public ShoulderEntityModuleState( final class_3222 player )
    {
        this.loadFromPlayer( player );
    }

    @Override
    public void applyToPlayer( final class_3222 player )
    {
        ((ServerPlayerEntityAccessor) player).invokeSetLeftShoulderNbt( this.leftShoulderEntity );
        ((ServerPlayerEntityAccessor) player).invokeSetRightShoulderNbt( this.rightShoulderEntity );
        ((ServerPlayerEntityAccessor) player).setShoulderMountTime( this.shoulderEntityAddedTime );
    }

    @Override
    public void loadFromPlayer( final class_3222 player )
    {
        this.leftShoulderEntity = player.method_74074();
        this.rightShoulderEntity = player.method_74075();
        this.shoulderEntityAddedTime = ((ServerPlayerEntityAccessor) player).getShoulderMountTime();
    }

    @Override
    public Type type()
    {
        return ShoulderEntityModuleState.class;
    }
}
