package net.thomilist.dimensionalinventories.module.builtin.status;

import net.minecraft.class_1293;
import net.minecraft.class_3222;
import net.thomilist.dimensionalinventories.mixin.HungerManagerAccessor;
import net.thomilist.dimensionalinventories.module.base.player.PlayerModuleState;
import net.thomilist.dimensionalinventories.util.ExperienceHelper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

public class StatusModuleState
    implements PlayerModuleState
{
    public int experiencePoints = 0;
    public int score = 0;
    public int foodLevel = 20;
    public float saturationLevel = 5.0f;
    public float exhaustion = 0.0f;
    public float health = 20.0f;
    public Collection<class_1293> statusEffects = new ArrayList<>();

    public StatusModuleState()
    { }

    public StatusModuleState( final class_3222 player )
    {
        this.loadFromPlayer( player );
    }

    @Override
    public Type type()
    {
        return StatusModuleState.class;
    }

    @Override
    public void applyToPlayer( final class_3222 player )
    {
        ExperienceHelper.setExperience( player, this.experiencePoints );
        player.method_7320( this.score );
        player.method_7344().method_7580( this.foodLevel );
        player.method_7344().method_7581( this.saturationLevel );
        ((HungerManagerAccessor) player.method_7344()).setExhaustion( this.exhaustion );
        player.method_6033( this.health );

        player.method_6012();

        for ( final class_1293 statusEffect : this.statusEffects )
        {
            player.method_6092( statusEffect );
        }
    }

    @Override
    public void loadFromPlayer( final class_3222 player )
    {
        this.experiencePoints = ExperienceHelper.getTotalExperience_Meridanus( player );
        this.score = player.method_7272();
        this.foodLevel = player.method_7344().method_7586();
        this.saturationLevel = player.method_7344().method_7589();
        this.exhaustion = ((HungerManagerAccessor) player.method_7344()).getExhaustion();
        this.health = player.method_6032();

        this.statusEffects = player.method_6026();
    }
}
