package net.thomilist.dimensionalinventories.util;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_2535;
import net.minecraft.class_2598;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8791;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import java.util.UUID;

// Intended to hold data during data migrations: load the old format to this, save this to the new format
public class DummyServerPlayerEntity
    extends class_3222
{
    private static final String DUMMY_NAME = "TempPlayer";

    private DummyServerPlayerEntity( final MinecraftServer server, final class_3218 world, final GameProfile profile )
    {
        super( server, world, profile, class_8791.method_53821() );

        // Set a non-null network handler to avoid NullPointerException in ServerPlayerEntity#changeGameMode
        this.field_13987 = new class_3244(
            server,
            new class_2535( class_2598.field_11942 ),
            this,
            class_8792.method_53824( this.method_7334(), false )
        );
    }

    private DummyServerPlayerEntity( final class_3218 world, final GameProfile profile )
    {
        this( world.method_8503(), world, profile );
    }

    private DummyServerPlayerEntity( final MinecraftServer server, final GameProfile profile )
    {
        this( server, server.method_30002(), profile );
    }

    public DummyServerPlayerEntity( final class_3218 world, final UUID uuid )
    {
        this( world, new GameProfile( uuid, DummyServerPlayerEntity.DUMMY_NAME ) );
    }

    public DummyServerPlayerEntity( final MinecraftServer server, final UUID uuid )
    {
        this( server, new GameProfile( uuid, DummyServerPlayerEntity.DUMMY_NAME ) );
    }

    public DummyServerPlayerEntity( final class_3218 world, final String uuid )
    {
        this( world, UUID.fromString( uuid ) );
    }

    public DummyServerPlayerEntity( final MinecraftServer server, final String uuid )
    {
        this( server, UUID.fromString( uuid ) );
    }

    public DummyServerPlayerEntity( final MinecraftServer server )
    {
        this( server, UUID.randomUUID() );
    }

    public DummyServerPlayerEntity( final class_3218 world )
    {
        this( world, UUID.randomUUID() );
    }
}
