/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_7918;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolConfigModule;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolOperationResult;

public class Commands {
    private DimensionPoolConfigModule dimensionPoolConfig;

    private static String versionString() {
        return "%s %s by %s".formatted(DimensionalInventories.PROPERTIES.namePretty(), DimensionalInventories.PROPERTIES.version(), DimensionalInventories.PROPERTIES.authorsPretty());
    }

    public void register(DimensionPoolConfigModule dimensionPoolConfig) {
        this.dimensionPoolConfig = dimensionPoolConfig;
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)DimensionalInventoriesCommand.ROOT.toString()).requires(source -> source.method_9259(4))).executes(this::printVersion)).then(class_2170.method_9247((String)DimensionalInventoriesCommand.LIST_POOLS.toString()).executes(this::listAllDimensionPools))).then(class_2170.method_9247((String)DimensionalInventoriesCommand.POOL.toString()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)DimensionalInventoriesCommand.POOL_ID.toString(), (ArgumentType)StringArgumentType.word()).then(class_2170.method_9247((String)DimensionalInventoriesCommand.LIST_DIMENSIONS_IN_POOL.toString()).executes(this::listDimensionPool))).then(class_2170.method_9247((String)DimensionalInventoriesCommand.CREATE_POOL.toString()).executes(this::createDimensionPool))).then(class_2170.method_9247((String)DimensionalInventoriesCommand.DELETE_POOL.toString()).executes(this::removeDimensionPool))).then(class_2170.method_9247((String)DimensionalInventoriesCommand.DIMENSION.toString()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)DimensionalInventoriesCommand.DIMENSION_NAME.toString(), (ArgumentType)class_2181.method_9288()).then(class_2170.method_9247((String)DimensionalInventoriesCommand.ASSIGN_DIMENSION_TO_POOL.toString()).executes(this::assignDimensionToPool))).then(class_2170.method_9247((String)DimensionalInventoriesCommand.REMOVE_DIMENSION_FROM_POOL.toString()).executes(this::removeDimensionFromPool))))).then(class_2170.method_9247((String)DimensionalInventoriesCommand.GAME_MODE.toString()).then(class_2170.method_9244((String)DimensionalInventoriesCommand.GAME_MODE_NAME.toString(), (ArgumentType)class_7918.method_47383()).executes(this::setDimensionPoolGameMode)))).then(class_2170.method_9247((String)DimensionalInventoriesCommand.PROGRESS_ADVANCEMENTS.toString()).then(class_2170.method_9244((String)DimensionalInventoriesCommand.PROGRESS_ADVANCEMENTS_ENABLED.toString(), (ArgumentType)BoolArgumentType.bool()).executes(this::setProgressAdvancementsInPool)))).then(class_2170.method_9247((String)DimensionalInventoriesCommand.INCREMENT_STATISTICS.toString()).then(class_2170.method_9244((String)DimensionalInventoriesCommand.INCREMENT_STATISTICS_ENABLED.toString(), (ArgumentType)BoolArgumentType.bool()).executes(this::setIncrementStatisticsInPool))))));
    }

    public int printVersion(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)Commands.versionString()), false);
        return 1;
    }

    public int listAllDimensionPools(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)this.dimensionPoolConfig.state().asString()), false);
        return 1;
    }

    public int listDimensionPool(CommandContext<class_2168> context) {
        String dimensionPoolId = StringArgumentType.getString(context, (String)DimensionalInventoriesCommand.POOL_ID.toString());
        Optional<DimensionPool> pool = this.dimensionPoolConfig.state().poolWithId(dimensionPoolId);
        if (pool.isEmpty()) {
            this.sendFeedback(context, "Unable to fetch pool '" + dimensionPoolId + "'");
            return -1;
        }
        this.sendFeedback(context, "Dimension pool:" + pool.get().asString());
        return 1;
    }

    public void sendFeedback(CommandContext<class_2168> context, String message) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)message), false);
    }

    public int createDimensionPool(CommandContext<class_2168> context) {
        String dimensionPoolId = StringArgumentType.getString(context, (String)DimensionalInventoriesCommand.POOL_ID.toString());
        DimensionPoolOperationResult result = this.dimensionPoolConfig.state().createPool(dimensionPoolId, class_1934.field_28045);
        if (!result.success()) {
            this.sendFeedback(context, "Unable to create dimension pool: '" + dimensionPoolId + "' already exists");
            return -1;
        }
        this.dimensionPoolConfig.saveWithContext();
        this.sendFeedback(context, "Dimension pool '" + dimensionPoolId + "' created");
        return 1;
    }

    public int removeDimensionPool(CommandContext<class_2168> context) {
        String dimensionPoolId = StringArgumentType.getString(context, (String)DimensionalInventoriesCommand.POOL_ID.toString());
        DimensionPoolOperationResult result = this.dimensionPoolConfig.state().deletePool(dimensionPoolId);
        if (!result.success()) {
            this.sendFeedback(context, "Unable to remove dimension pool: '" + dimensionPoolId + "' does not exist");
            return -1;
        }
        this.dimensionPoolConfig.saveWithContext();
        this.sendFeedback(context, "Dimension pool '" + dimensionPoolId + "' removed");
        return 1;
    }

    public int assignDimensionToPool(CommandContext<class_2168> context) {
        class_3218 dimension;
        String dimensionPoolId = StringArgumentType.getString(context, (String)DimensionalInventoriesCommand.POOL_ID.toString());
        try {
            dimension = class_2181.method_9289(context, (String)DimensionalInventoriesCommand.DIMENSION_NAME.toString());
        }
        catch (CommandSyntaxException e) {
            this.sendFeedback(context, "Unable to fetch dimension");
            return -1;
        }
        String dimensionName = dimension.method_27983().method_29177().toString();
        DimensionPoolOperationResult result = this.dimensionPoolConfig.state().assignDimensionToPool(dimensionName, dimensionPoolId);
        if (!result.success()) {
            this.sendFeedback(context, "'" + dimensionPoolId + "' is not a valid dimension pool ID");
            return -1;
        }
        switch (result.operation()) {
            case ADD_DIMENSION: {
                this.sendFeedback(context, "Assigned dimension '" + result.target() + "' to dimension pool '" + result.to() + "'");
                break;
            }
            case MOVE_DIMENSION: {
                this.sendFeedback(context, "Moved dimension '" + result.target() + "' from dimension pool '" + result.from() + "' to '" + result.to() + "'");
                break;
            }
            case NO_OP: {
                this.sendFeedback(context, "Dimension '" + result.target() + "' is already in dimension pool '" + result.to() + "'");
            }
        }
        this.dimensionPoolConfig.saveWithContext();
        return 1;
    }

    public int removeDimensionFromPool(CommandContext<class_2168> context) {
        class_3218 dimension;
        String dimensionPoolId = StringArgumentType.getString(context, (String)DimensionalInventoriesCommand.POOL_ID.toString());
        try {
            dimension = class_2181.method_9289(context, (String)DimensionalInventoriesCommand.DIMENSION_NAME.toString());
        }
        catch (CommandSyntaxException e) {
            this.sendFeedback(context, "Unable to fetch dimension");
            return -1;
        }
        String dimensionName = dimension.method_27983().method_29177().toString();
        DimensionPoolOperationResult result = this.dimensionPoolConfig.state().removeDimensionFromPool(dimensionName, dimensionPoolId);
        if (!result.success()) {
            this.sendFeedback(context, "'" + dimensionPoolId + "' is not a valid dimension pool ID");
            return -1;
        }
        switch (result.operation()) {
            case REMOVE_DIMENSION: {
                this.sendFeedback(context, "Removed dimension '" + dimensionName + "' from dimension pool '" + dimensionPoolId + "'");
                break;
            }
            case NO_OP: {
                this.sendFeedback(context, "Dimension '" + dimensionName + "' not found in dimension pool '" + dimensionPoolId + "'");
            }
        }
        this.dimensionPoolConfig.saveWithContext();
        return 1;
    }

    public int setDimensionPoolGameMode(CommandContext<class_2168> context) {
        class_1934 gameMode;
        String dimensionPoolId = StringArgumentType.getString(context, (String)DimensionalInventoriesCommand.POOL_ID.toString());
        try {
            gameMode = class_7918.method_47385(context, (String)DimensionalInventoriesCommand.GAME_MODE_NAME.toString());
        }
        catch (CommandSyntaxException e) {
            this.sendFeedback(context, "Invalid game mode");
            return -1;
        }
        Optional<DimensionPool> pool = this.dimensionPoolConfig.state().poolWithId(dimensionPoolId);
        if (pool.isEmpty()) {
            this.sendFeedback(context, "Unable to fetch dimension pool '" + dimensionPoolId + "'");
            return -1;
        }
        pool.get().setGameMode(gameMode);
        this.dimensionPoolConfig.saveWithContext();
        this.sendFeedback(context, "Game mode '" + gameMode.method_15434() + "' set for dimension pool '" + dimensionPoolId + "'");
        return 1;
    }

    public int setProgressAdvancementsInPool(CommandContext<class_2168> context) {
        String dimensionPoolId = StringArgumentType.getString(context, (String)DimensionalInventoriesCommand.POOL_ID.toString());
        boolean progressAdvancements = BoolArgumentType.getBool(context, (String)DimensionalInventoriesCommand.PROGRESS_ADVANCEMENTS_ENABLED.toString());
        Optional<DimensionPool> pool = this.dimensionPoolConfig.state().poolWithId(dimensionPoolId);
        if (pool.isEmpty()) {
            this.sendFeedback(context, "Unable to fetch dimension pool '" + dimensionPoolId + "'");
            return -1;
        }
        pool.get().setProgressAdvancements(progressAdvancements);
        this.dimensionPoolConfig.saveWithContext();
        if (progressAdvancements) {
            this.sendFeedback(context, "Players can now progress advancements while in the dimension pool '" + dimensionPoolId + "'");
        } else {
            this.sendFeedback(context, "Players can no longer progress advancements while in the dimension pool '" + dimensionPoolId + "'");
        }
        return 1;
    }

    public int setIncrementStatisticsInPool(CommandContext<class_2168> context) {
        String dimensionPoolId = StringArgumentType.getString(context, (String)DimensionalInventoriesCommand.POOL_ID.toString());
        boolean incrementStatistics = BoolArgumentType.getBool(context, (String)DimensionalInventoriesCommand.INCREMENT_STATISTICS_ENABLED.toString());
        Optional<DimensionPool> pool = this.dimensionPoolConfig.state().poolWithId(dimensionPoolId);
        if (pool.isEmpty()) {
            this.sendFeedback(context, "Unable to fetch pool '" + dimensionPoolId + "'");
            return -1;
        }
        pool.get().setIncrementStatistics(incrementStatistics);
        this.dimensionPoolConfig.saveWithContext();
        if (incrementStatistics) {
            this.sendFeedback(context, "Players can now increment statistics while in the dimension pool '" + dimensionPoolId + "'");
        } else {
            this.sendFeedback(context, "Players can no longer increment statistics while in the dimension pool '" + dimensionPoolId + "'");
        }
        return 1;
    }

    private static enum DimensionalInventoriesCommand {
        ROOT("diminv"),
        LIST_POOLS("list"),
        POOL("pool"),
        POOL_ID("poolId"),
        LIST_DIMENSIONS_IN_POOL("list"),
        CREATE_POOL("create"),
        DELETE_POOL("delete"),
        DIMENSION("dimension"),
        DIMENSION_NAME("dimensionName"),
        ASSIGN_DIMENSION_TO_POOL("assign"),
        REMOVE_DIMENSION_FROM_POOL("remove"),
        GAME_MODE("gameMode"),
        GAME_MODE_NAME("gameModeName"),
        PROGRESS_ADVANCEMENTS("progressAdvancements"),
        PROGRESS_ADVANCEMENTS_ENABLED("progressAdvancementsEnabled"),
        INCREMENT_STATISTICS("incrementStatistics"),
        INCREMENT_STATISTICS_ENABLED("incrementStatisticsEnabled");

        private final String command;

        private DimensionalInventoriesCommand(String command) {
            this.command = command;
        }

        public String toString() {
            return this.command;
        }
    }
}

