/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.exception;

import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.module.version.StorageVersion;

public class StorageVersionMigrationException
extends RuntimeException {
    private static final String MESSAGE_PREFIX = "Failed to migrate Dimensional Inventories data";

    public StorageVersionMigrationException(StorageVersion from, StorageVersion to) {
        super(MESSAGE_PREFIX);
        StorageVersionMigrationException.logMigrationStep(from, to, null);
    }

    public StorageVersionMigrationException(StorageVersion from, StorageVersion to, String message) {
        super(StorageVersionMigrationException.formatMessage(message));
        StorageVersionMigrationException.logMigrationStep(from, to, null);
    }

    public StorageVersionMigrationException(StorageVersion from, StorageVersion to, String message, Throwable cause) {
        super(StorageVersionMigrationException.formatMessage(message), cause);
        StorageVersionMigrationException.logMigrationStep(from, to, cause);
    }

    private static void logMigrationStep(StorageVersion from, StorageVersion to, Throwable cause) {
        DimensionalInventories.LOGGER.error("Failed to migrate storage from version {} to {}", (Object)from.version, (Object)to.version);
        if (cause != null) {
            DimensionalInventories.LOGGER.error("Caused by:", cause);
        }
    }

    private static String formatMessage(String message) {
        return "Failed to migrate Dimensional Inventories data: " + message;
    }
}

