/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.mixin;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_179;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.compatibility.Compat;
import net.thomilist.dimensionalinventories.compatibility.LimitedCompatibility;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolConfigModule;
import net.thomilist.dimensionalinventories.util.LogThrottler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@LimitedCompatibility(target="Minecraft", versions=">=1.20.3")
@Mixin(value={class_4558.class})
public abstract class DisableAdvancementProgressMixin<T extends class_4558.class_8788>
implements class_179<T> {
    @Unique
    private static final LogThrottler LOG_THROTTLER = new LogThrottler(10000);
    @Unique
    private static DimensionPoolConfigModule DIMENSION_POOL_CONFIG;

    @Unique
    private static DimensionPoolConfigModule dimensionPoolConfig() {
        if (DIMENSION_POOL_CONFIG == null) {
            DIMENSION_POOL_CONFIG = DimensionalInventories.INSTANCE.configModules.get(DimensionPoolConfigModule.class);
        }
        return DIMENSION_POOL_CONFIG;
    }

    @Inject(at={@At(value="HEAD")}, method={"method_22510(Lnet/minecraft/class_3222;Ljava/util/function/Predicate;)V"}, cancellable=true)
    public void trigger(class_3222 player, Predicate<T> predicate, CallbackInfo info) {
        String dimensionName = Compat.ENTITY.getWorld(player).method_27983().method_29177().toString();
        Optional<DimensionPool> pool = DisableAdvancementProgressMixin.dimensionPoolConfig().state().poolWithDimension(dimensionName, LOG_THROTTLER.get());
        if (pool.isPresent() && !pool.get().canProgressAdvancements()) {
            info.cancel();
        }
    }
}

