/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.mixin;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.compatibility.Compat;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPool;
import net.thomilist.dimensionalinventories.module.builtin.pool.DimensionPoolConfigModule;
import net.thomilist.dimensionalinventories.util.LogThrottler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class DisableStatisticIncrementMixin
extends class_1309 {
    @Unique
    private static final LogThrottler LOG_THROTTLER = new LogThrottler(10000);
    @Unique
    private static DimensionPoolConfigModule DIMENSION_POOL_CONFIG;

    protected DisableStatisticIncrementMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(class_1299.field_6097, world);
    }

    @Unique
    private static DimensionPoolConfigModule dimensionPoolConfig() {
        if (DIMENSION_POOL_CONFIG == null) {
            DIMENSION_POOL_CONFIG = DimensionalInventories.INSTANCE.configModules.get(DimensionPoolConfigModule.class);
        }
        return DIMENSION_POOL_CONFIG;
    }

    @Inject(at={@At(value="HEAD")}, method={"method_7281(Lnet/minecraft/class_2960;)V"}, cancellable=true)
    public void incrementStat(class_2960 stat, CallbackInfo info) {
        if (!this.canPoolIncrementStatistics()) {
            info.cancel();
        }
    }

    @Unique
    public boolean canPoolIncrementStatistics() {
        String dimensionName = Compat.ENTITY.getWorld((class_1297)this).method_27983().method_29177().toString();
        Optional<DimensionPool> pool = DisableStatisticIncrementMixin.dimensionPoolConfig().state().poolWithDimension(dimensionName, LOG_THROTTLER.get());
        return pool.map(DimensionPool::canIncrementStatistics).orElse(true);
    }

    @Inject(at={@At(value="HEAD")}, method={"method_7339(Lnet/minecraft/class_2960;I)V"}, cancellable=true)
    public void increaseStat(class_2960 stat, int amount, CallbackInfo info) {
        if (!this.canPoolIncrementStatistics()) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_7259(Lnet/minecraft/class_3445;)V"}, cancellable=true)
    public void incrementStat(class_3445<?> stat, CallbackInfo info) {
        if (!this.canPoolIncrementStatistics()) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_7342(Lnet/minecraft/class_3445;I)V"}, cancellable=true)
    public void increaseStat(class_3445<?> stat, int amount, CallbackInfo info) {
        if (!this.canPoolIncrementStatistics()) {
            info.cancel();
        }
    }
}

