/*
 * Decompiled with CFR 0.152.
 */
package net.thomilist.dimensionalinventories.module;

import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.class_151;
import net.thomilist.dimensionalinventories.DimensionalInventories;
import net.thomilist.dimensionalinventories.exception.InvalidModuleException;
import net.thomilist.dimensionalinventories.exception.ModuleConstructionException;
import net.thomilist.dimensionalinventories.module.ModuleRegistry;
import net.thomilist.dimensionalinventories.module.base.Module;
import net.thomilist.dimensionalinventories.module.base.ModuleBase;
import net.thomilist.dimensionalinventories.module.base.config.ConfigModule;
import net.thomilist.dimensionalinventories.module.base.player.PlayerModule;
import net.thomilist.dimensionalinventories.util.StringHelper;

public abstract class ModuleGroup {
    final SortedSet<Module> modules = new TreeSet<Module>();
    private final String groupId;

    protected ModuleGroup(String groupId) {
        this.groupId = groupId;
    }

    public String groupId() {
        return this.groupId;
    }

    @SafeVarargs
    protected final void register(Class<? extends Module> ... moduleTypes) throws class_151, InvalidModuleException, ModuleConstructionException {
        for (Class<? extends Module> moduleType : moduleTypes) {
            Module module = ModuleBase.createDerived(moduleType, this.groupId);
            this.register(module);
        }
    }

    private void register(Module ... modules) throws class_151, InvalidModuleException {
        for (Module module : modules) {
            if (!ModuleRegistry.isValidId(module.moduleId())) {
                throw new class_151("'%s' is not a valid module ID".formatted(module.moduleId()));
            }
            if (!(module instanceof ConfigModule) && !(module instanceof PlayerModule)) {
                throw new InvalidModuleException(module.getClass(), this.groupId, module.moduleId());
            }
            if (this.modules.add(module)) continue;
            DimensionalInventories.LOGGER.warn("Failed to add module: {} has already been registered", (Object)StringHelper.joinAndWrapScopes(module.groupId(), module.moduleId()));
        }
    }
}

